/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.DataInputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;

public abstract class StringHelper {
    public static final int GOOD_FAST_HASH_SEED;

    private StringHelper() {
    }

    public static int murmurhash3_x86_32(BytesRef bytes, int seed) {
        Object object;
        int n;
        int n2 = n;
        int n3 = ((BytesRef)object).length;
        n = bytes.offset;
        object = bytes.bytes;
        int n4 = n + (n3 & 0xFFFFFFFC);
        while (n < n4) {
            int n5 = BitUtil.VH_LE_INT.get((byte[])object, n);
            n5 *= -862048943;
            n5 = Integer.rotateLeft(n5, 15);
            n2 ^= (n5 *= 461845907);
            n2 = Integer.rotateLeft(n2, 13);
            n2 = n2 * 5 + -430675100;
            n += 4;
        }
        n = 0;
        switch (n3 & 3) {
            case 3: {
                n = (object[n4 + 2] & 0xFF) << 16;
            }
            case 2: {
                n |= (object[n4 + 1] & 0xFF) << 8;
            }
            case 1: {
                n |= object[n4] & 0xFF;
                n *= -862048943;
                n = Integer.rotateLeft(n, 15);
                n2 ^= (n *= 461845907);
            }
        }
        n2 ^= n3;
        n2 ^= n2 >>> 16;
        n2 *= -2048144789;
        n2 ^= n2 >>> 13;
        n2 *= -1028477387;
        n2 ^= n2 >>> 16;
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_3;
        void var0_2;
        long x1;
        long x0;
        StringHelper.class.desiredAssertionStatus();
        String prop = System.getProperty("tests.seed");
        GOOD_FAST_HASH_SEED = prop != null ? prop.hashCode() : (int)System.currentTimeMillis();
        new Object();
        byte[] maskBytes128 = new byte[16];
        Arrays.fill(maskBytes128, (byte)-1);
        new BigInteger(1, maskBytes128);
        prop = System.getProperty("tests.seed");
        if (prop != null) {
            if (prop.length() > 8) {
                String string = prop;
                prop = string.substring(string.length() - 8);
            }
            x1 = x0 = Long.parseLong(prop, 16);
        } else {
            try (DataInputStream is = new DataInputStream(Files.newInputStream(Paths.get("/dev/urandom", new String[0]), new OpenOption[0]));){
                x0 = is.readLong();
                x1 = is.readLong();
            }
            catch (Exception exception) {
                x0 = System.nanoTime();
                x1 = (long)StringHelper.class.hashCode() << 32;
                StringBuilder sb = new StringBuilder();
                try {
                    Properties p = System.getProperties();
                    for (String s : p.stringPropertyNames()) {
                        sb.append(s);
                        sb.append(p.getProperty(s));
                    }
                    x1 |= (long)sb.toString().hashCode();
                }
                catch (SecurityException securityException) {
                    x1 |= (long)StringBuffer.class.hashCode();
                }
            }
        }
        for (int i = 0; i < 10; ++i) {
            long s0;
            long s1 = x0;
            x0 = s0 = x1;
            long l = s1;
            s1 = l ^ l << 23;
            x1 = s1 ^ s0 ^ s1 >>> 17 ^ s0 >>> 26;
        }
        byte[] maskBytes64 = new byte[8];
        Arrays.fill(maskBytes64, (byte)-1);
        BigInteger mask64 = new BigInteger(1, (byte[])var0_2);
        BigInteger unsignedX0 = BigInteger.valueOf((long)var2_3).and(mask64);
        BigInteger unsignedX1 = BigInteger.valueOf(x1).and(mask64);
        unsignedX0.shiftLeft(64).or(unsignedX1);
    }
}

