/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.api;

import com.io7m.immutables.styles.ImmutablesStyleType;
import com.io7m.jaffirm.core.Preconditions;
import com.io7m.jwheatsheaf.api.JWFileChooserAction;
import com.io7m.jwheatsheaf.api.JWFileChooserConfigurationDefaults;
import com.io7m.jwheatsheaf.api.JWFileChooserFilterType;
import com.io7m.jwheatsheaf.api.JWFileImageSetType;
import com.io7m.jwheatsheaf.api.JWFileSizeFormatterType;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@ImmutablesStyleType
@Value.Immutable
public interface JWFileChooserConfigurationType {
    public List<Path> recentFiles();

    public FileSystem fileSystem();

    public Optional<Path> initialDirectory();

    public Optional<Path> homeDirectory();

    public Optional<String> initialFileName();

    public Optional<String> title();

    public Optional<JWFileImageSetType> fileImageSet();

    public Optional<URL> cssStylesheet();

    public List<JWFileChooserFilterType> fileFilters();

    @Value.Default
    default public boolean allowDirectoryCreation() {
        return true;
    }

    @Value.Default
    default public DateTimeFormatter fileTimeFormatter() {
        return JWFileChooserConfigurationDefaults.fileTimeFormatter();
    }

    @Value.Default
    default public JWFileSizeFormatterType fileSizeFormatter() {
        return JWFileChooserConfigurationDefaults.fileSizeFormatter();
    }

    @Value.Default
    default public JWFileChooserAction action() {
        return JWFileChooserAction.OPEN_EXISTING_SINGLE;
    }

    @Value.Check
    default public void checkPreconditions() {
        this.initialDirectory().ifPresent(path -> Preconditions.checkPreconditionV((boolean)path.getFileSystem().equals(this.fileSystem()), (String)"Path %s must belong to filesystem %s", (Object[])new Object[]{path, this.fileSystem()}));
        for (Path path2 : this.recentFiles()) {
            Preconditions.checkPreconditionV((boolean)path2.getFileSystem().equals(this.fileSystem()), (String)"Path %s must belong to filesystem %s", (Object[])new Object[]{path2, this.fileSystem()});
        }
    }
}

