/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jwheatsheaf.ui.internal.JWFileItem;
import com.io7m.jwheatsheaf.ui.internal.JWToolTips;
import java.util.Objects;
import javafx.scene.control.TableCell;

final class JWFileItemTableNameCell
extends TableCell<JWFileItem, JWFileItem> {
    private final JWToolTips toolTips;

    JWFileItemTableNameCell(JWToolTips inToolTips) {
        this.toolTips = Objects.requireNonNull(inToolTips, "inToolTips");
    }

    protected void updateItem(JWFileItem item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.setText(null);
            this.setTooltip(null);
            return;
        }
        this.setGraphic(null);
        this.setText(item.name());
        this.setTooltip(this.toolTips.tooltipOf(item));
    }
}

