/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jwheatsheaf.api.JWFileSizeFormatterType;
import com.io7m.jwheatsheaf.ui.internal.JWFileItem;
import java.util.Objects;
import javafx.scene.control.TableCell;

final class JWFileItemTableSizeCell
extends TableCell<JWFileItem, Long> {
    private final JWFileSizeFormatterType sizeFormatter;

    JWFileItemTableSizeCell(JWFileSizeFormatterType inSizeFormatter) {
        this.sizeFormatter = Objects.requireNonNull(inSizeFormatter, "inSizeFormatter");
    }

    protected void updateItem(Long item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.setText(null);
            return;
        }
        this.setText(this.sizeFormatter.formatSize(item.longValue()));
        this.setGraphic(null);
    }
}

