/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jwheatsheaf.api.JWFileImageSetType;
import com.io7m.jwheatsheaf.ui.internal.JWFileItem;
import com.io7m.jwheatsheaf.ui.internal.JWImages;
import com.io7m.jwheatsheaf.ui.internal.JWToolTips;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.TableCell;

final class JWFileItemTableTypeCell
extends TableCell<JWFileItem, JWFileItem> {
    private final JWToolTips toolTips;
    private final JWFileImageSetType images;

    JWFileItemTableTypeCell(JWFileImageSetType inImages, JWToolTips inToolTips) {
        this.images = Objects.requireNonNull(inImages, "inImages");
        this.toolTips = Objects.requireNonNull(inToolTips, "inToolTips");
    }

    protected void updateItem(JWFileItem item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.setText(null);
            this.setTooltip(null);
            return;
        }
        this.setGraphic((Node)JWImages.imageOfKind(this.images, item.kind()));
        this.setText(null);
        this.setTooltip(this.toolTips.tooltipOf(item));
    }
}

