/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jaffirm.core.Preconditions;
import com.io7m.jwheatsheaf.api.JWFileImageSetType;
import com.io7m.jwheatsheaf.ui.internal.JWFileItem;
import com.io7m.jwheatsheaf.ui.internal.JWFileItems;
import com.io7m.jwheatsheaf.ui.internal.JWFileSourceEntryType;
import com.io7m.jwheatsheaf.ui.internal.JWImages;
import com.io7m.jwheatsheaf.ui.internal.JWStrings;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ListCell;

public final class JWFileSourceEntryFilesystemRoot
implements JWFileSourceEntryType {
    private final Path root;

    public JWFileSourceEntryFilesystemRoot(Path inRoot) {
        this.root = Objects.requireNonNull(inRoot, "root");
    }

    @Override
    public void onListCell(JWFileImageSetType images, JWStrings strings, ListCell<JWFileSourceEntryType> cell) {
        Preconditions.checkPreconditionV((boolean)Platform.isFxApplicationThread(), (String)"Must be FX application thread", (Object[])new Object[0]);
        cell.setText(this.root.toString());
        cell.setGraphic((Node)JWImages.imageView16x16Of(images.forFileSystem()));
    }

    @Override
    public Optional<Path> path() {
        return Optional.of(this.root);
    }

    @Override
    public List<JWFileItem> onFileItemsRequested() throws Exception {
        Preconditions.checkPreconditionV((!Platform.isFxApplicationThread() ? 1 : 0) != 0, (String)"Must not be FX application thread", (Object[])new Object[0]);
        return JWFileItems.listDirectory(this.root);
    }
}

