/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermFrequencyAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeReflector;

public class PackedTokenAttributeImpl
extends CharTermAttributeImpl
implements OffsetAttribute,
PositionIncrementAttribute,
PositionLengthAttribute,
TermFrequencyAttribute,
TypeAttribute {
    private int startOffset;
    private int endOffset;
    private String type = "word";
    private int positionIncrement = 1;
    private int positionLength = 1;
    private int termFrequency = 1;

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setPositionIncrement(int positionIncrement) {
        void var1_1;
        if (positionIncrement < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + positionIncrement);
        }
        this.positionIncrement = var1_1;
    }

    @Override
    public final int getPositionIncrement() {
        return this.positionIncrement;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setPositionLength(int positionLength) {
        void var1_1;
        if (positionLength <= 0) {
            throw new IllegalArgumentException("Position length must be 1 or greater: got " + positionLength);
        }
        this.positionLength = var1_1;
    }

    @Override
    public final int startOffset() {
        return this.startOffset;
    }

    @Override
    public final int endOffset() {
        return this.endOffset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setOffset(int startOffset, int endOffset) {
        void var2_2;
        void var1_1;
        if (startOffset < 0 || endOffset < startOffset) {
            throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset; got startOffset=" + startOffset + ",endOffset=" + endOffset);
        }
        this.startOffset = var1_1;
        this.endOffset = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setType(String type) {
        void var1_1;
        this.type = var1_1;
    }

    @Override
    public final void clear() {
        super.clear();
        PackedTokenAttributeImpl packedTokenAttributeImpl = this;
        packedTokenAttributeImpl.positionLength = 1;
        packedTokenAttributeImpl.positionIncrement = 1;
        this.termFrequency = 1;
        PackedTokenAttributeImpl packedTokenAttributeImpl2 = this;
        packedTokenAttributeImpl2.endOffset = 0;
        packedTokenAttributeImpl2.startOffset = 0;
        this.type = "word";
    }

    @Override
    public final void end() {
        super.end();
        this.positionIncrement = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PackedTokenAttributeImpl) {
            void var1_1;
            void var2_2;
            PackedTokenAttributeImpl other = (PackedTokenAttributeImpl)obj;
            return this.startOffset == other.startOffset && this.endOffset == other.endOffset && this.positionIncrement == other.positionIncrement && this.positionLength == other.positionLength && (this.type == null ? other.type == null : this.type.equals(other.type)) && this.termFrequency == var2_2.termFrequency && super.equals(var1_1);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.startOffset;
        n = n * 31 + this.endOffset;
        n = n * 31 + this.positionIncrement;
        int code = n * 31 + this.positionLength;
        if (this.type != null) {
            code = code * 31 + this.type.hashCode();
        }
        n = n * 31 + this.termFrequency;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void reflectWith(AttributeReflector reflector) {
        void var1_1;
        super.reflectWith(reflector);
        reflector.reflect(OffsetAttribute.class, "startOffset", this.startOffset);
        reflector.reflect(OffsetAttribute.class, "endOffset", this.endOffset);
        reflector.reflect(PositionIncrementAttribute.class, "positionIncrement", this.positionIncrement);
        reflector.reflect(PositionLengthAttribute.class, "positionLength", this.positionLength);
        reflector.reflect(TypeAttribute.class, "type", this.type);
        var1_1.reflect(TermFrequencyAttribute.class, "termFrequency", this.termFrequency);
    }
}

