/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.api;

import com.io7m.jwheatsheaf.api.JWFileChooserEventType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;

public final class JWDirectoryCreationFailed
implements JWFileChooserEventType.JWDirectoryCreationFailedType {
    private final Path path;
    private final Exception exception;

    private JWDirectoryCreationFailed(Path path, Exception exception) {
        this.path = Objects.requireNonNull(path, "path");
        this.exception = Objects.requireNonNull(exception, "exception");
    }

    private JWDirectoryCreationFailed(JWDirectoryCreationFailed original, Path path, Exception exception) {
        this.path = path;
        this.exception = exception;
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public Exception exception() {
        return this.exception;
    }

    public final JWDirectoryCreationFailed withPath(Path value) {
        if (this.path == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "path");
        return new JWDirectoryCreationFailed(this, newValue, this.exception);
    }

    public final JWDirectoryCreationFailed withException(Exception value) {
        if (this.exception == value) {
            return this;
        }
        Exception newValue = Objects.requireNonNull(value, "exception");
        return new JWDirectoryCreationFailed(this, this.path, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JWDirectoryCreationFailed && this.equalTo((JWDirectoryCreationFailed)another);
    }

    private boolean equalTo(JWDirectoryCreationFailed another) {
        return this.path.equals(another.path) && this.exception.equals(another.exception);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.exception.hashCode();
        return h;
    }

    public String toString() {
        return "JWDirectoryCreationFailed{path=" + this.path + ", exception=" + this.exception + "}";
    }

    public static JWDirectoryCreationFailed of(Path path, Exception exception) {
        return new JWDirectoryCreationFailed(path, exception);
    }

    public static JWDirectoryCreationFailed copyOf(JWFileChooserEventType.JWDirectoryCreationFailedType instance) {
        if (instance instanceof JWDirectoryCreationFailed) {
            return (JWDirectoryCreationFailed)instance;
        }
        return JWDirectoryCreationFailed.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_EXCEPTION = 2L;
        private long initBits = 3L;
        private Path path;
        private Exception exception;

        private Builder() {
        }

        public final Builder from(JWFileChooserEventType.JWFileChooserEventErrorType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JWFileChooserEventType.JWDirectoryCreationFailedType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            JWFileChooserEventType.JWFileChooserEventErrorType instance;
            long bits = 0L;
            if (object instanceof JWFileChooserEventType.JWFileChooserEventErrorType) {
                instance = (JWFileChooserEventType.JWFileChooserEventErrorType)object;
                if ((bits & 1L) == 0L) {
                    this.setException(instance.exception());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setPath(instance.path());
                    bits |= 2L;
                }
            }
            if (object instanceof JWFileChooserEventType.JWDirectoryCreationFailedType) {
                instance = (JWFileChooserEventType.JWDirectoryCreationFailedType)object;
                if ((bits & 1L) == 0L) {
                    this.setException(instance.exception());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setPath(instance.path());
                    bits |= 2L;
                }
            }
        }

        public final Builder setPath(Path path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setException(Exception exception) {
            this.exception = Objects.requireNonNull(exception, "exception");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public JWDirectoryCreationFailed build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new JWDirectoryCreationFailed(null, this.path, this.exception);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("exception");
            }
            return "Cannot build JWDirectoryCreationFailed, some of required attributes are not set " + attributes;
        }
    }
}

