/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.api;

import com.io7m.jwheatsheaf.api.JWFileChooserAction;
import com.io7m.jwheatsheaf.api.JWFileChooserConfigurationType;
import com.io7m.jwheatsheaf.api.JWFileChooserFilterType;
import com.io7m.jwheatsheaf.api.JWFileImageSetType;
import com.io7m.jwheatsheaf.api.JWFileSizeFormatterType;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class JWFileChooserConfiguration
implements JWFileChooserConfigurationType {
    private final List<Path> recentFiles;
    private final FileSystem fileSystem;
    private final Path initialDirectory;
    private final Path homeDirectory;
    private final String initialFileName;
    private final String title;
    private final JWFileImageSetType fileImageSet;
    private final URL cssStylesheet;
    private final List<JWFileChooserFilterType> fileFilters;
    private final boolean allowDirectoryCreation;
    private final DateTimeFormatter fileTimeFormatter;
    private final JWFileSizeFormatterType fileSizeFormatter;
    private final JWFileChooserAction action;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private JWFileChooserConfiguration(Builder builder) {
        this.recentFiles = JWFileChooserConfiguration.createUnmodifiableList(true, builder.recentFiles);
        this.fileSystem = builder.fileSystem;
        this.initialDirectory = builder.initialDirectory;
        this.homeDirectory = builder.homeDirectory;
        this.initialFileName = builder.initialFileName;
        this.title = builder.title;
        this.fileImageSet = builder.fileImageSet;
        this.cssStylesheet = builder.cssStylesheet;
        this.fileFilters = JWFileChooserConfiguration.createUnmodifiableList(true, builder.fileFilters);
        if (builder.allowDirectoryCreationIsSet()) {
            this.initShim.setAllowDirectoryCreation(builder.allowDirectoryCreation);
        }
        if (builder.fileTimeFormatter != null) {
            this.initShim.setFileTimeFormatter(builder.fileTimeFormatter);
        }
        if (builder.fileSizeFormatter != null) {
            this.initShim.setFileSizeFormatter(builder.fileSizeFormatter);
        }
        if (builder.action != null) {
            this.initShim.setAction(builder.action);
        }
        this.allowDirectoryCreation = this.initShim.allowDirectoryCreation();
        this.fileTimeFormatter = this.initShim.fileTimeFormatter();
        this.fileSizeFormatter = this.initShim.fileSizeFormatter();
        this.action = this.initShim.action();
        this.initShim = null;
    }

    private JWFileChooserConfiguration(List<Path> recentFiles, FileSystem fileSystem, Path initialDirectory, Path homeDirectory, String initialFileName, String title, JWFileImageSetType fileImageSet, URL cssStylesheet, List<JWFileChooserFilterType> fileFilters, boolean allowDirectoryCreation, DateTimeFormatter fileTimeFormatter, JWFileSizeFormatterType fileSizeFormatter, JWFileChooserAction action) {
        this.recentFiles = recentFiles;
        this.fileSystem = fileSystem;
        this.initialDirectory = initialDirectory;
        this.homeDirectory = homeDirectory;
        this.initialFileName = initialFileName;
        this.title = title;
        this.fileImageSet = fileImageSet;
        this.cssStylesheet = cssStylesheet;
        this.fileFilters = fileFilters;
        this.allowDirectoryCreation = allowDirectoryCreation;
        this.fileTimeFormatter = fileTimeFormatter;
        this.fileSizeFormatter = fileSizeFormatter;
        this.action = action;
        this.initShim = null;
    }

    private boolean allowDirectoryCreationInitialize() {
        return JWFileChooserConfigurationType.super.allowDirectoryCreation();
    }

    private DateTimeFormatter fileTimeFormatterInitialize() {
        return JWFileChooserConfigurationType.super.fileTimeFormatter();
    }

    private JWFileSizeFormatterType fileSizeFormatterInitialize() {
        return JWFileChooserConfigurationType.super.fileSizeFormatter();
    }

    private JWFileChooserAction actionInitialize() {
        return JWFileChooserConfigurationType.super.action();
    }

    @Override
    public List<Path> recentFiles() {
        return this.recentFiles;
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public Optional<Path> initialDirectory() {
        return Optional.ofNullable(this.initialDirectory);
    }

    @Override
    public Optional<Path> homeDirectory() {
        return Optional.ofNullable(this.homeDirectory);
    }

    @Override
    public Optional<String> initialFileName() {
        return Optional.ofNullable(this.initialFileName);
    }

    @Override
    public Optional<String> title() {
        return Optional.ofNullable(this.title);
    }

    @Override
    public Optional<JWFileImageSetType> fileImageSet() {
        return Optional.ofNullable(this.fileImageSet);
    }

    @Override
    public Optional<URL> cssStylesheet() {
        return Optional.ofNullable(this.cssStylesheet);
    }

    @Override
    public List<JWFileChooserFilterType> fileFilters() {
        return this.fileFilters;
    }

    @Override
    public boolean allowDirectoryCreation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allowDirectoryCreation() : this.allowDirectoryCreation;
    }

    @Override
    public DateTimeFormatter fileTimeFormatter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileTimeFormatter() : this.fileTimeFormatter;
    }

    @Override
    public JWFileSizeFormatterType fileSizeFormatter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSizeFormatter() : this.fileSizeFormatter;
    }

    @Override
    public JWFileChooserAction action() {
        InitShim shim = this.initShim;
        return shim != null ? shim.action() : this.action;
    }

    public final JWFileChooserConfiguration withRecentFiles(Path ... elements) {
        List<Path> newValue = JWFileChooserConfiguration.createUnmodifiableList(false, JWFileChooserConfiguration.createSafeList(Arrays.asList(elements), true, false));
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(newValue, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withRecentFiles(Iterable<? extends Path> elements) {
        if (this.recentFiles == elements) {
            return this;
        }
        List<Path> newValue = JWFileChooserConfiguration.createUnmodifiableList(false, JWFileChooserConfiguration.createSafeList(elements, true, false));
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(newValue, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withFileSystem(FileSystem value) {
        if (this.fileSystem == value) {
            return this;
        }
        FileSystem newValue = Objects.requireNonNull(value, "fileSystem");
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, newValue, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withInitialDirectory(Path value) {
        Path newValue = Objects.requireNonNull(value, "initialDirectory");
        if (this.initialDirectory == newValue) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, newValue, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withInitialDirectory(Optional<? extends Path> optional) {
        Path value = optional.orElse(null);
        if (this.initialDirectory == value) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, value, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withHomeDirectory(Path value) {
        Path newValue = Objects.requireNonNull(value, "homeDirectory");
        if (this.homeDirectory == newValue) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, newValue, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withHomeDirectory(Optional<? extends Path> optional) {
        Path value = optional.orElse(null);
        if (this.homeDirectory == value) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, value, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withInitialFileName(String value) {
        String newValue = Objects.requireNonNull(value, "initialFileName");
        if (Objects.equals(this.initialFileName, newValue)) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, newValue, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withInitialFileName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.initialFileName, value)) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, value, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, newValue, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, value, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withFileImageSet(JWFileImageSetType value) {
        JWFileImageSetType newValue = Objects.requireNonNull(value, "fileImageSet");
        if (this.fileImageSet == newValue) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, newValue, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withFileImageSet(Optional<? extends JWFileImageSetType> optional) {
        JWFileImageSetType value = optional.orElse(null);
        if (this.fileImageSet == value) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, value, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withCssStylesheet(URL value) {
        URL newValue = Objects.requireNonNull(value, "cssStylesheet");
        if (this.cssStylesheet == newValue) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, newValue, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withCssStylesheet(Optional<? extends URL> optional) {
        URL value = optional.orElse(null);
        if (this.cssStylesheet == value) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, value, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withFileFilters(JWFileChooserFilterType ... elements) {
        List<JWFileChooserFilterType> newValue = JWFileChooserConfiguration.createUnmodifiableList(false, JWFileChooserConfiguration.createSafeList(Arrays.asList(elements), true, false));
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, newValue, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withFileFilters(Iterable<? extends JWFileChooserFilterType> elements) {
        if (this.fileFilters == elements) {
            return this;
        }
        List<JWFileChooserFilterType> newValue = JWFileChooserConfiguration.createUnmodifiableList(false, JWFileChooserConfiguration.createSafeList(elements, true, false));
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, newValue, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withAllowDirectoryCreation(boolean value) {
        if (this.allowDirectoryCreation == value) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, value, this.fileTimeFormatter, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withFileTimeFormatter(DateTimeFormatter value) {
        if (this.fileTimeFormatter == value) {
            return this;
        }
        DateTimeFormatter newValue = Objects.requireNonNull(value, "fileTimeFormatter");
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, newValue, this.fileSizeFormatter, this.action));
    }

    public final JWFileChooserConfiguration withFileSizeFormatter(JWFileSizeFormatterType value) {
        if (this.fileSizeFormatter == value) {
            return this;
        }
        JWFileSizeFormatterType newValue = Objects.requireNonNull(value, "fileSizeFormatter");
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, newValue, this.action));
    }

    public final JWFileChooserConfiguration withAction(JWFileChooserAction value) {
        if (this.action == value) {
            return this;
        }
        JWFileChooserAction newValue = Objects.requireNonNull(value, "action");
        if (this.action.equals((Object)newValue)) {
            return this;
        }
        return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this.recentFiles, this.fileSystem, this.initialDirectory, this.homeDirectory, this.initialFileName, this.title, this.fileImageSet, this.cssStylesheet, this.fileFilters, this.allowDirectoryCreation, this.fileTimeFormatter, this.fileSizeFormatter, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JWFileChooserConfiguration && this.equalTo((JWFileChooserConfiguration)another);
    }

    private boolean equalTo(JWFileChooserConfiguration another) {
        return this.recentFiles.equals(another.recentFiles) && this.fileSystem.equals(another.fileSystem) && Objects.equals(this.initialDirectory, another.initialDirectory) && Objects.equals(this.homeDirectory, another.homeDirectory) && Objects.equals(this.initialFileName, another.initialFileName) && Objects.equals(this.title, another.title) && Objects.equals(this.fileImageSet, another.fileImageSet) && Objects.equals(this.cssStylesheet, another.cssStylesheet) && this.fileFilters.equals(another.fileFilters) && this.allowDirectoryCreation == another.allowDirectoryCreation && this.fileTimeFormatter.equals(another.fileTimeFormatter) && this.fileSizeFormatter.equals(another.fileSizeFormatter) && this.action.equals((Object)another.action);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.recentFiles.hashCode();
        h += (h << 5) + this.fileSystem.hashCode();
        h += (h << 5) + Objects.hashCode(this.initialDirectory);
        h += (h << 5) + Objects.hashCode(this.homeDirectory);
        h += (h << 5) + Objects.hashCode(this.initialFileName);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.fileImageSet);
        h += (h << 5) + Objects.hashCode(this.cssStylesheet);
        h += (h << 5) + this.fileFilters.hashCode();
        h += (h << 5) + Boolean.hashCode(this.allowDirectoryCreation);
        h += (h << 5) + this.fileTimeFormatter.hashCode();
        h += (h << 5) + this.fileSizeFormatter.hashCode();
        h += (h << 5) + this.action.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("JWFileChooserConfiguration{");
        builder.append("recentFiles=").append(this.recentFiles);
        builder.append(", ");
        builder.append("fileSystem=").append(this.fileSystem);
        if (this.initialDirectory != null) {
            builder.append(", ");
            builder.append("initialDirectory=").append(this.initialDirectory);
        }
        if (this.homeDirectory != null) {
            builder.append(", ");
            builder.append("homeDirectory=").append(this.homeDirectory);
        }
        if (this.initialFileName != null) {
            builder.append(", ");
            builder.append("initialFileName=").append(this.initialFileName);
        }
        if (this.title != null) {
            builder.append(", ");
            builder.append("title=").append(this.title);
        }
        if (this.fileImageSet != null) {
            builder.append(", ");
            builder.append("fileImageSet=").append(this.fileImageSet);
        }
        if (this.cssStylesheet != null) {
            builder.append(", ");
            builder.append("cssStylesheet=").append(this.cssStylesheet);
        }
        builder.append(", ");
        builder.append("fileFilters=").append(this.fileFilters);
        builder.append(", ");
        builder.append("allowDirectoryCreation=").append(this.allowDirectoryCreation);
        builder.append(", ");
        builder.append("fileTimeFormatter=").append(this.fileTimeFormatter);
        builder.append(", ");
        builder.append("fileSizeFormatter=").append(this.fileSizeFormatter);
        builder.append(", ");
        builder.append("action=").append((Object)this.action);
        return builder.append("}").toString();
    }

    private static JWFileChooserConfiguration validate(JWFileChooserConfiguration instance) {
        instance.checkPreconditions();
        return instance;
    }

    public static JWFileChooserConfiguration copyOf(JWFileChooserConfigurationType instance) {
        if (instance instanceof JWFileChooserConfiguration) {
            return (JWFileChooserConfiguration)instance;
        }
        return JWFileChooserConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private final class InitShim {
        private byte allowDirectoryCreationBuildStage = 0;
        private boolean allowDirectoryCreation;
        private byte fileTimeFormatterBuildStage = 0;
        private DateTimeFormatter fileTimeFormatter;
        private byte fileSizeFormatterBuildStage = 0;
        private JWFileSizeFormatterType fileSizeFormatter;
        private byte actionBuildStage = 0;
        private JWFileChooserAction action;

        private InitShim() {
        }

        boolean allowDirectoryCreation() {
            if (this.allowDirectoryCreationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowDirectoryCreationBuildStage == 0) {
                this.allowDirectoryCreationBuildStage = (byte)-1;
                this.allowDirectoryCreation = JWFileChooserConfiguration.this.allowDirectoryCreationInitialize();
                this.allowDirectoryCreationBuildStage = 1;
            }
            return this.allowDirectoryCreation;
        }

        void setAllowDirectoryCreation(boolean allowDirectoryCreation) {
            this.allowDirectoryCreation = allowDirectoryCreation;
            this.allowDirectoryCreationBuildStage = 1;
        }

        DateTimeFormatter fileTimeFormatter() {
            if (this.fileTimeFormatterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileTimeFormatterBuildStage == 0) {
                this.fileTimeFormatterBuildStage = (byte)-1;
                this.fileTimeFormatter = Objects.requireNonNull(JWFileChooserConfiguration.this.fileTimeFormatterInitialize(), "fileTimeFormatter");
                this.fileTimeFormatterBuildStage = 1;
            }
            return this.fileTimeFormatter;
        }

        void setFileTimeFormatter(DateTimeFormatter fileTimeFormatter) {
            this.fileTimeFormatter = fileTimeFormatter;
            this.fileTimeFormatterBuildStage = 1;
        }

        JWFileSizeFormatterType fileSizeFormatter() {
            if (this.fileSizeFormatterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSizeFormatterBuildStage == 0) {
                this.fileSizeFormatterBuildStage = (byte)-1;
                this.fileSizeFormatter = Objects.requireNonNull(JWFileChooserConfiguration.this.fileSizeFormatterInitialize(), "fileSizeFormatter");
                this.fileSizeFormatterBuildStage = 1;
            }
            return this.fileSizeFormatter;
        }

        void setFileSizeFormatter(JWFileSizeFormatterType fileSizeFormatter) {
            this.fileSizeFormatter = fileSizeFormatter;
            this.fileSizeFormatterBuildStage = 1;
        }

        JWFileChooserAction action() {
            if (this.actionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.actionBuildStage == 0) {
                this.actionBuildStage = (byte)-1;
                this.action = Objects.requireNonNull(JWFileChooserConfiguration.this.actionInitialize(), "action");
                this.actionBuildStage = 1;
            }
            return this.action;
        }

        void setAction(JWFileChooserAction action) {
            this.action = action;
            this.actionBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.allowDirectoryCreationBuildStage == -1) {
                attributes.add("allowDirectoryCreation");
            }
            if (this.fileTimeFormatterBuildStage == -1) {
                attributes.add("fileTimeFormatter");
            }
            if (this.fileSizeFormatterBuildStage == -1) {
                attributes.add("fileSizeFormatter");
            }
            if (this.actionBuildStage == -1) {
                attributes.add("action");
            }
            return "Cannot build JWFileChooserConfiguration, attribute initializers form cycle " + attributes;
        }
    }

    public static final class Builder {
        private static final long INIT_BIT_FILE_SYSTEM = 1L;
        private static final long OPT_BIT_ALLOW_DIRECTORY_CREATION = 1L;
        private long initBits = 1L;
        private long optBits;
        private List<Path> recentFiles = new ArrayList<Path>();
        private FileSystem fileSystem;
        private Path initialDirectory;
        private Path homeDirectory;
        private String initialFileName;
        private String title;
        private JWFileImageSetType fileImageSet;
        private URL cssStylesheet;
        private List<JWFileChooserFilterType> fileFilters = new ArrayList<JWFileChooserFilterType>();
        private boolean allowDirectoryCreation;
        private DateTimeFormatter fileTimeFormatter;
        private JWFileSizeFormatterType fileSizeFormatter;
        private JWFileChooserAction action;

        private Builder() {
        }

        public final Builder from(JWFileChooserConfigurationType instance) {
            Optional<URL> cssStylesheetOptional;
            Optional<JWFileImageSetType> fileImageSetOptional;
            Optional<String> titleOptional;
            Optional<String> initialFileNameOptional;
            Optional<Path> homeDirectoryOptional;
            Objects.requireNonNull(instance, "instance");
            this.addAllRecentFiles(instance.recentFiles());
            this.setFileSystem(instance.fileSystem());
            Optional<Path> initialDirectoryOptional = instance.initialDirectory();
            if (initialDirectoryOptional.isPresent()) {
                this.setInitialDirectory(initialDirectoryOptional);
            }
            if ((homeDirectoryOptional = instance.homeDirectory()).isPresent()) {
                this.setHomeDirectory(homeDirectoryOptional);
            }
            if ((initialFileNameOptional = instance.initialFileName()).isPresent()) {
                this.setInitialFileName(initialFileNameOptional);
            }
            if ((titleOptional = instance.title()).isPresent()) {
                this.setTitle(titleOptional);
            }
            if ((fileImageSetOptional = instance.fileImageSet()).isPresent()) {
                this.setFileImageSet(fileImageSetOptional);
            }
            if ((cssStylesheetOptional = instance.cssStylesheet()).isPresent()) {
                this.setCssStylesheet(cssStylesheetOptional);
            }
            this.addAllFileFilters(instance.fileFilters());
            this.setAllowDirectoryCreation(instance.allowDirectoryCreation());
            this.setFileTimeFormatter(instance.fileTimeFormatter());
            this.setFileSizeFormatter(instance.fileSizeFormatter());
            this.setAction(instance.action());
            return this;
        }

        public final Builder addRecentFiles(Path element) {
            this.recentFiles.add(Objects.requireNonNull(element, "recentFiles element"));
            return this;
        }

        public final Builder addRecentFiles(Path ... elements) {
            for (Path element : elements) {
                this.recentFiles.add(Objects.requireNonNull(element, "recentFiles element"));
            }
            return this;
        }

        public final Builder setRecentFiles(Iterable<? extends Path> elements) {
            this.recentFiles.clear();
            return this.addAllRecentFiles(elements);
        }

        public final Builder addAllRecentFiles(Iterable<? extends Path> elements) {
            for (Path path : elements) {
                this.recentFiles.add(Objects.requireNonNull(path, "recentFiles element"));
            }
            return this;
        }

        public final Builder setFileSystem(FileSystem fileSystem) {
            this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setInitialDirectory(Path initialDirectory) {
            this.initialDirectory = Objects.requireNonNull(initialDirectory, "initialDirectory");
            return this;
        }

        public final Builder setInitialDirectory(Optional<? extends Path> initialDirectory) {
            this.initialDirectory = initialDirectory.orElse(null);
            return this;
        }

        public final Builder setHomeDirectory(Path homeDirectory) {
            this.homeDirectory = Objects.requireNonNull(homeDirectory, "homeDirectory");
            return this;
        }

        public final Builder setHomeDirectory(Optional<? extends Path> homeDirectory) {
            this.homeDirectory = homeDirectory.orElse(null);
            return this;
        }

        public final Builder setInitialFileName(String initialFileName) {
            this.initialFileName = Objects.requireNonNull(initialFileName, "initialFileName");
            return this;
        }

        public final Builder setInitialFileName(Optional<String> initialFileName) {
            this.initialFileName = initialFileName.orElse(null);
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        public final Builder setTitle(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        public final Builder setFileImageSet(JWFileImageSetType fileImageSet) {
            this.fileImageSet = Objects.requireNonNull(fileImageSet, "fileImageSet");
            return this;
        }

        public final Builder setFileImageSet(Optional<? extends JWFileImageSetType> fileImageSet) {
            this.fileImageSet = fileImageSet.orElse(null);
            return this;
        }

        public final Builder setCssStylesheet(URL cssStylesheet) {
            this.cssStylesheet = Objects.requireNonNull(cssStylesheet, "cssStylesheet");
            return this;
        }

        public final Builder setCssStylesheet(Optional<? extends URL> cssStylesheet) {
            this.cssStylesheet = cssStylesheet.orElse(null);
            return this;
        }

        public final Builder addFileFilters(JWFileChooserFilterType element) {
            this.fileFilters.add(Objects.requireNonNull(element, "fileFilters element"));
            return this;
        }

        public final Builder addFileFilters(JWFileChooserFilterType ... elements) {
            for (JWFileChooserFilterType element : elements) {
                this.fileFilters.add(Objects.requireNonNull(element, "fileFilters element"));
            }
            return this;
        }

        public final Builder setFileFilters(Iterable<? extends JWFileChooserFilterType> elements) {
            this.fileFilters.clear();
            return this.addAllFileFilters(elements);
        }

        public final Builder addAllFileFilters(Iterable<? extends JWFileChooserFilterType> elements) {
            for (JWFileChooserFilterType jWFileChooserFilterType : elements) {
                this.fileFilters.add(Objects.requireNonNull(jWFileChooserFilterType, "fileFilters element"));
            }
            return this;
        }

        public final Builder setAllowDirectoryCreation(boolean allowDirectoryCreation) {
            this.allowDirectoryCreation = allowDirectoryCreation;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setFileTimeFormatter(DateTimeFormatter fileTimeFormatter) {
            this.fileTimeFormatter = Objects.requireNonNull(fileTimeFormatter, "fileTimeFormatter");
            return this;
        }

        public final Builder setFileSizeFormatter(JWFileSizeFormatterType fileSizeFormatter) {
            this.fileSizeFormatter = Objects.requireNonNull(fileSizeFormatter, "fileSizeFormatter");
            return this;
        }

        public final Builder setAction(JWFileChooserAction action) {
            this.action = Objects.requireNonNull(action, "action");
            return this;
        }

        public JWFileChooserConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return JWFileChooserConfiguration.validate(new JWFileChooserConfiguration(this));
        }

        private boolean allowDirectoryCreationIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fileSystem");
            }
            return "Cannot build JWFileChooserConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

