/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes;

import com.whitemagicsoftware.keenquotes.CircularFifoQueue;
import com.whitemagicsoftware.keenquotes.Contractions;
import com.whitemagicsoftware.keenquotes.Lexeme;
import com.whitemagicsoftware.keenquotes.LexemeType;
import com.whitemagicsoftware.keenquotes.Lexer;
import com.whitemagicsoftware.keenquotes.Token;
import com.whitemagicsoftware.keenquotes.TokenType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class Parser {
    private static final LexemeType[] LEADING_QUOTE_OPENING_SINGLE = new LexemeType[]{LexemeType.SPACE, LexemeType.DASH, LexemeType.QUOTE_DOUBLE, LexemeType.OPENING_GROUP, LexemeType.EOL, LexemeType.EOP};
    private static final LexemeType[] LAGGING_QUOTE_OPENING_SINGLE = new LexemeType[]{LexemeType.WORD, LexemeType.ELLIPSIS, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_DOUBLE};
    private static final LexemeType[] LEADING_QUOTE_CLOSING_SINGLE = new LexemeType[]{LexemeType.WORD, LexemeType.NUMBER, LexemeType.PERIOD, LexemeType.PUNCT, LexemeType.ELLIPSIS, LexemeType.QUOTE_DOUBLE};
    private static final LexemeType[] LAGGING_QUOTE_CLOSING_SINGLE = new LexemeType[]{LexemeType.SPACE, LexemeType.HYPHEN, LexemeType.DASH, LexemeType.QUOTE_DOUBLE, LexemeType.CLOSING_GROUP, LexemeType.EOL, LexemeType.EOP};
    private static final LexemeType[] LEADING_QUOTE_OPENING_DOUBLE = new LexemeType[]{LexemeType.SPACE, LexemeType.DASH, LexemeType.EQUALS, LexemeType.QUOTE_SINGLE, LexemeType.OPENING_GROUP, LexemeType.EOL, LexemeType.EOP};
    private static final LexemeType[] LAGGING_QUOTE_OPENING_DOUBLE = new LexemeType[]{LexemeType.WORD, LexemeType.NUMBER, LexemeType.DASH, LexemeType.ELLIPSIS, LexemeType.OPENING_GROUP, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_SINGLE_OPENING, LexemeType.QUOTE_SINGLE_CLOSING, LexemeType.QUOTE_DOUBLE};
    private static final LexemeType[] LEADING_QUOTE_CLOSING_DOUBLE = new LexemeType[]{LexemeType.WORD, LexemeType.NUMBER, LexemeType.PERIOD, LexemeType.PUNCT, LexemeType.DASH, LexemeType.ELLIPSIS, LexemeType.CLOSING_GROUP, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_SINGLE_CLOSING, LexemeType.QUOTE_SINGLE_OPENING};
    private static final LexemeType[] LAGGING_QUOTE_CLOSING_DOUBLE = new LexemeType[]{LexemeType.SPACE, LexemeType.PUNCT, LexemeType.PERIOD, LexemeType.EQUALS, LexemeType.HYPHEN, LexemeType.DASH, LexemeType.QUOTE_SINGLE, LexemeType.CLOSING_GROUP, LexemeType.EOL, LexemeType.EOP};
    private final String mText;
    private final Lexer mLexer;
    private final Contractions sContractions;
    private final List<Lexeme> mOpeningSingleQuotes = new ArrayList<Lexeme>();
    private final List<Lexeme> mClosingSingleQuotes = new ArrayList<Lexeme>();
    private final List<Lexeme> mOpeningDoubleQuotes = new ArrayList<Lexeme>();
    private final List<Lexeme> mClosingDoubleQuotes = new ArrayList<Lexeme>();

    public Parser(String text, Contractions contractions) {
        this.mText = text;
        this.mLexer = this.createLexer(this.mText);
        this.sContractions = contractions;
    }

    public void parse(Consumer<Token> tokenConsumer, Consumer<Lexeme> lexemeConsumer) {
        Lexeme lexeme;
        CircularFifoQueue<Lexeme> lexemes = new CircularFifoQueue<Lexeme>(3);
        this.flush(lexemes);
        ArrayList<Lexeme[]> unresolved = new ArrayList<Lexeme[]>();
        while ((lexeme = this.mLexer.next()) != Lexeme.EOT) {
            if (!this.tokenize(lexeme, lexemes, tokenConsumer, unresolved)) continue;
            this.resolve(unresolved, tokenConsumer);
            unresolved.forEach(lex -> lexemeConsumer.accept(lex[1]));
            unresolved.clear();
            this.mOpeningSingleQuotes.clear();
            this.mClosingSingleQuotes.clear();
            this.mOpeningDoubleQuotes.clear();
            this.mClosingDoubleQuotes.clear();
        }
        this.tokenize(Lexeme.EOT, lexemes, tokenConsumer, unresolved);
        this.tokenize(Lexeme.EOT, lexemes, tokenConsumer, unresolved);
        this.resolve(unresolved, tokenConsumer);
        unresolved.forEach(lex -> lexemeConsumer.accept(lex[1]));
    }

    private boolean tokenize(Lexeme lexeme, CircularFifoQueue<Lexeme> lexemes, Consumer<Token> consumer, List<Lexeme[]> unresolved) {
        lexemes.add(lexeme);
        Lexeme lex1 = lexemes.get(0);
        Lexeme lex2 = lexemes.get(1);
        Lexeme lex3 = lexemes.get(2);
        if (lex2.isType(LexemeType.QUOTE_SINGLE) && lex3.isType(LexemeType.WORD) && lex1.isType(LexemeType.WORD, LexemeType.PERIOD, LexemeType.NUMBER)) {
            consumer.accept(new Token(TokenType.QUOTE_APOSTROPHE, lex2));
        } else if (lex1.isType(LexemeType.QUOTE_SINGLE) && lex3.isType(LexemeType.QUOTE_SINGLE) && "n".equalsIgnoreCase(lex2.toString(this.mText))) {
            consumer.accept(new Token(TokenType.QUOTE_APOSTROPHE, lex1));
            consumer.accept(new Token(TokenType.QUOTE_APOSTROPHE, lex3));
            this.flush(lexemes);
            this.truncate(unresolved);
        } else if (lex2.isType(LexemeType.QUOTE_SINGLE) && lex1.isType(LexemeType.NUMBER)) {
            if (lex3.isType(LexemeType.QUOTE_SINGLE)) {
                consumer.accept(new Token(TokenType.QUOTE_PRIME_DOUBLE, lex2.began(), lex3.ended()));
                this.flush(lexemes);
            } else {
                consumer.accept(new Token(TokenType.QUOTE_PRIME_SINGLE, lex2));
            }
        } else if (lex2.isType(LexemeType.QUOTE_DOUBLE) && lex1.isType(LexemeType.NUMBER)) {
            consumer.accept(new Token(TokenType.QUOTE_PRIME_DOUBLE, lex2));
        } else if (lex2.isType(LexemeType.WORD) && lex3.isType(LexemeType.QUOTE_SINGLE) && this.sContractions.endedUnambiguously(lex2.toString(this.mText))) {
            consumer.accept(new Token(TokenType.QUOTE_APOSTROPHE, lex3));
            this.flush(lexemes);
        } else if (lex2.isType(LexemeType.NUMBER) && lex1.isType(LexemeType.QUOTE_SINGLE)) {
            if (lex3.isType(LexemeType.SPACE, LexemeType.PUNCT) || lex3.isType(LexemeType.WORD) && lex3.toString(this.mText).equalsIgnoreCase("s")) {
                consumer.accept(new Token(TokenType.QUOTE_APOSTROPHE, lex1));
            } else {
                consumer.accept(new Token(TokenType.QUOTE_OPENING_SINGLE, lex1));
                this.mOpeningSingleQuotes.add(lex1);
            }
            this.truncate(unresolved);
        } else if (lex2.isType(LexemeType.QUOTE_SINGLE) && lex1.isType(LexemeType.PUNCT, LexemeType.PERIOD, LexemeType.ELLIPSIS, LexemeType.DASH) && (lex3.isType(LexemeType.EOL, LexemeType.EOP) || lex3.isEot())) {
            consumer.accept(new Token(TokenType.QUOTE_CLOSING_SINGLE, lex2));
            this.mClosingSingleQuotes.add(lex2);
        } else if (lex1.isType(LexemeType.ESC_SINGLE)) {
            consumer.accept(new Token(TokenType.QUOTE_STRAIGHT_SINGLE, lex1));
        } else if (lex1.isType(LexemeType.ESC_DOUBLE)) {
            consumer.accept(new Token(TokenType.QUOTE_STRAIGHT_DOUBLE, lex1));
            if (lex2.isType(LexemeType.QUOTE_SINGLE) && (lex3.isEot() || lex3.isType(LexemeType.SPACE, LexemeType.DASH, LexemeType.EOL, LexemeType.EOP))) {
                consumer.accept(new Token(TokenType.QUOTE_CLOSING_SINGLE, lex2));
                this.mClosingSingleQuotes.add(lex2);
            }
        } else if (lex2.isType(LexemeType.QUOTE_DOUBLE) && (lex1.isSot() || lex1.isType(LEADING_QUOTE_OPENING_DOUBLE)) && lex3.isType(LAGGING_QUOTE_OPENING_DOUBLE)) {
            consumer.accept(new Token(TokenType.QUOTE_OPENING_DOUBLE, lex2));
            this.mOpeningDoubleQuotes.add(lex2);
        } else if (lex2.isType(LexemeType.QUOTE_DOUBLE) && lex1.isType(LEADING_QUOTE_CLOSING_DOUBLE) && (lex3.isEot() || lex3.isType(LAGGING_QUOTE_CLOSING_DOUBLE))) {
            consumer.accept(new Token(TokenType.QUOTE_CLOSING_DOUBLE, lex2));
            this.mClosingDoubleQuotes.add(lex2);
        } else if (lex1.isType(LexemeType.WORD) && lex2.isType(LexemeType.QUOTE_SINGLE) && lex3.isType(LexemeType.PUNCT, LexemeType.PERIOD)) {
            consumer.accept(new Token(TokenType.QUOTE_CLOSING_SINGLE, lex2));
            this.mClosingSingleQuotes.add(lex2);
        } else if (lex2.isType(LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_DOUBLE)) {
            unresolved.add(new Lexeme[]{lex1, lex2, lex3});
        }
        return lex3.isType(LexemeType.EOP);
    }

    private void resolve(List<Lexeme[]> unresolved, Consumer<Token> consumer) {
        Lexeme[] opening;
        Lexeme[] closing;
        ArrayList<Lexeme[]> ambiguousLeadingQuotes = new ArrayList<Lexeme[]>(16);
        ArrayList<Lexeme[]> ambiguousLaggingQuotes = new ArrayList<Lexeme[]>(16);
        int resolvedLeadingQuotes = 0;
        int resolvedLaggingQuotes = 0;
        Iterator<Lexeme[]> i = unresolved.iterator();
        while (i.hasNext()) {
            String word3;
            Lexeme[] quotes = i.next();
            Lexeme lex1 = quotes[0];
            Lexeme lex2 = quotes[1];
            Lexeme lex3 = quotes[2];
            if (!lex2.isType(LexemeType.QUOTE_SINGLE)) continue;
            String word1 = lex1 == Lexeme.SOT ? "" : lex1.toString(this.mText);
            String string = word3 = lex3 == Lexeme.EOT ? "" : lex3.toString(this.mText);
            if (this.sContractions.beganAmbiguously(word3)) {
                if (lex1.isType(LexemeType.QUOTE_SINGLE)) {
                    consumer.accept(new Token(TokenType.QUOTE_APOSTROPHE, lex2));
                    i.remove();
                    continue;
                }
                ambiguousLeadingQuotes.add(quotes);
                continue;
            }
            if (this.sContractions.beganUnambiguously(word3)) {
                consumer.accept(new Token(TokenType.QUOTE_APOSTROPHE, lex2));
                i.remove();
                continue;
            }
            if (this.sContractions.endedAmbiguously(word1)) {
                ambiguousLaggingQuotes.add(quotes);
                continue;
            }
            if ((lex1.isSot() || lex1.isType(LEADING_QUOTE_OPENING_SINGLE)) && lex3.isType(LAGGING_QUOTE_OPENING_SINGLE)) {
                consumer.accept(new Token(TokenType.QUOTE_OPENING_SINGLE, lex2));
                ++resolvedLeadingQuotes;
                this.mOpeningSingleQuotes.add(lex2);
                i.remove();
                continue;
            }
            if (lex1.isType(LEADING_QUOTE_CLOSING_SINGLE) && (lex3.isEot() || lex3.isType(LAGGING_QUOTE_CLOSING_SINGLE))) {
                consumer.accept(new Token(TokenType.QUOTE_CLOSING_SINGLE, lex2));
                ++resolvedLaggingQuotes;
                this.mClosingSingleQuotes.add(lex2);
                i.remove();
                continue;
            }
            if (!lex3.isType(LexemeType.NUMBER)) continue;
            ambiguousLeadingQuotes.add(quotes);
        }
        Collections.sort(this.mOpeningSingleQuotes);
        Collections.sort(this.mClosingSingleQuotes);
        Collections.sort(this.mOpeningDoubleQuotes);
        Collections.sort(this.mClosingDoubleQuotes);
        boolean singleQuoteEmpty = this.mOpeningSingleQuotes.isEmpty() || this.mClosingSingleQuotes.isEmpty();
        boolean doubleQuoteEmpty = this.mOpeningDoubleQuotes.isEmpty() || this.mClosingDoubleQuotes.isEmpty();
        int singleQuoteDelta = Math.abs(this.mClosingSingleQuotes.size() - this.mOpeningSingleQuotes.size());
        int doubleQuoteDelta = Math.abs(this.mClosingDoubleQuotes.size() - this.mOpeningDoubleQuotes.size());
        int ambiguousLeadingCount = ambiguousLeadingQuotes.size();
        int ambiguousLaggingCount = ambiguousLaggingQuotes.size();
        if (resolvedLeadingQuotes == 1 && resolvedLaggingQuotes == 0) {
            if (ambiguousLeadingCount == 0 && ambiguousLaggingCount == 1) {
                boolean balanced = singleQuoteDelta == 0;
                TokenType quote = balanced ? TokenType.QUOTE_APOSTROPHE : TokenType.QUOTE_CLOSING_SINGLE;
                Lexeme[] lex2 = (Lexeme[])ambiguousLaggingQuotes.get(0);
                consumer.accept(new Token(quote, lex2[1]));
                unresolved.remove(lex2);
            } else if (ambiguousLeadingCount == 0 && unresolved.size() == 1) {
                closing = unresolved.get(0);
                consumer.accept(new Token(TokenType.QUOTE_CLOSING_SINGLE, closing[1]));
                unresolved.remove(closing);
            }
        } else if (ambiguousLeadingCount == 0 && ambiguousLaggingCount > 0) {
            ambiguousLaggingQuotes.forEach(lex -> {
                consumer.accept(new Token(TokenType.QUOTE_APOSTROPHE, lex[1]));
                unresolved.remove(lex);
            });
        } else if (this.mOpeningSingleQuotes.size() == 0 && this.mClosingSingleQuotes.size() == 1 && !unresolved.isEmpty()) {
            opening = unresolved.get(0);
            consumer.accept(new Token(TokenType.QUOTE_OPENING_SINGLE, opening[1]));
            unresolved.remove(opening);
        } else if (ambiguousLeadingCount == 0) {
            Iterator<Lexeme[]> i2;
            if (resolvedLaggingQuotes < resolvedLeadingQuotes) {
                i2 = unresolved.iterator();
                while (i2.hasNext()) {
                    Lexeme closing2 = i2.next()[1];
                    consumer.accept(new Token(TokenType.QUOTE_CLOSING_SINGLE, closing2));
                    i2.remove();
                }
            } else if (singleQuoteDelta == unresolved.size()) {
                i2 = unresolved.iterator();
                while (i2.hasNext()) {
                    Lexeme[] closing3 = i2.next();
                    consumer.accept(new Token(TokenType.QUOTE_CLOSING_SINGLE, closing3[1]));
                    i2.remove();
                }
            } else if (unresolved.size() == 2) {
                closing = unresolved.get(0);
                Lexeme[] opening2 = unresolved.get(1);
                consumer.accept(new Token(TokenType.QUOTE_CLOSING_SINGLE, closing[1]));
                consumer.accept(new Token(TokenType.QUOTE_OPENING_SINGLE, opening2[1]));
                unresolved.clear();
            }
        } else if (singleQuoteDelta == 0 && !singleQuoteEmpty || doubleQuoteDelta == 0 && !doubleQuoteEmpty) {
            Lexeme closingQuote;
            Lexeme openingQuote;
            int i3;
            Lexeme quote;
            Iterator<Lexeme[]> lexemes = unresolved.iterator();
            while (lexemes.hasNext()) {
                quote = lexemes.next()[1];
                for (i3 = 0; i3 < this.mOpeningSingleQuotes.size(); ++i3) {
                    openingQuote = this.mOpeningSingleQuotes.get(i3);
                    closingQuote = this.mClosingSingleQuotes.get(i3);
                    if (!openingQuote.before(quote) || !closingQuote.after(quote)) continue;
                    consumer.accept(new Token(TokenType.QUOTE_APOSTROPHE, quote));
                    lexemes.remove();
                }
            }
            lexemes = unresolved.iterator();
            while (lexemes.hasNext()) {
                quote = lexemes.next()[1];
                for (i3 = 0; i3 < this.mOpeningDoubleQuotes.size(); ++i3) {
                    openingQuote = this.mOpeningDoubleQuotes.get(i3);
                    closingQuote = this.mClosingDoubleQuotes.get(i3);
                    if (!openingQuote.before(quote) || !closingQuote.after(quote)) continue;
                    consumer.accept(new Token(TokenType.QUOTE_APOSTROPHE, quote));
                    lexemes.remove();
                }
            }
        } else if (ambiguousLeadingCount == 1 && resolvedLaggingQuotes == 1) {
            opening = (Lexeme[])ambiguousLeadingQuotes.get(0);
            consumer.accept(new Token(TokenType.QUOTE_OPENING_SINGLE, opening[1]));
            unresolved.remove(opening);
        }
    }

    Lexer createLexer(String text) {
        return new Lexer(text);
    }

    private void truncate(List<Lexeme[]> unresolved) {
        if (!unresolved.isEmpty()) {
            unresolved.remove(unresolved.size() - 1);
        }
    }

    private void flush(CircularFifoQueue<Lexeme> lexemes) {
        lexemes.add(Lexeme.SOT);
        lexemes.add(Lexeme.SOT);
        lexemes.add(Lexeme.SOT);
    }
}

