/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.junreachable.UnreachableCodeException;
import com.io7m.jwheatsheaf.api.JWFileImageSetType;
import com.io7m.jwheatsheaf.api.JWFileKind;
import java.net.URL;
import java.util.Optional;

public final class JWFileImageDefaultSet
implements JWFileImageSetType {
    private static Optional<URL> forName(String name) {
        return Optional.of(JWFileImageDefaultSet.class.getResource(String.format("/com/io7m/jwheatsheaf/ui/internal/%s", name)));
    }

    public URL forSelectDirect() {
        return JWFileImageDefaultSet.forName("targetDirect.png").orElseThrow();
    }

    public URL forDirectoryCreate() {
        return JWFileImageDefaultSet.forName("directoryCreate.png").orElseThrow();
    }

    public URL forDirectoryUp() {
        return JWFileImageDefaultSet.forName("goUp.png").orElseThrow();
    }

    public URL forHome() {
        return JWFileImageDefaultSet.forName("home.png").orElseThrow();
    }

    public URL forRecentItems() {
        return JWFileImageDefaultSet.forName("recentItems.png").orElseThrow();
    }

    public URL forFileSystem() {
        return JWFileImageDefaultSet.forName("filesystem.png").orElseThrow();
    }

    public Optional<URL> forFileKind(JWFileKind kind) {
        switch (kind) {
            case REGULAR_FILE: {
                return JWFileImageDefaultSet.forName("file.png");
            }
            case DIRECTORY: {
                return JWFileImageDefaultSet.forName("directory.png");
            }
            case SYMBOLIC_LINK: {
                return JWFileImageDefaultSet.forName("link.png");
            }
            case UNKNOWN: {
                return Optional.empty();
            }
        }
        throw new UnreachableCodeException();
    }
}

