/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jwheatsheaf.api.JWFileKind;
import com.io7m.jwheatsheaf.ui.internal.JWFileItemType;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class JWFileItem
implements JWFileItemType {
    private final JWFileKind kind;
    private final Path path;
    private final long size;
    private final FileTime modifiedTime;
    private final String displayName;

    private JWFileItem(JWFileKind kind, Path path, long size, FileTime modifiedTime, String displayName) {
        this.kind = kind;
        this.path = path;
        this.size = size;
        this.modifiedTime = modifiedTime;
        this.displayName = displayName;
    }

    @Override
    public JWFileKind kind() {
        return this.kind;
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public FileTime modifiedTime() {
        return this.modifiedTime;
    }

    @Override
    public Optional<String> displayName() {
        return Optional.ofNullable(this.displayName);
    }

    public final JWFileItem withKind(JWFileKind value) {
        if (this.kind == value) {
            return this;
        }
        JWFileKind newValue = Objects.requireNonNull(value, "kind");
        if (this.kind.equals((Object)newValue)) {
            return this;
        }
        return new JWFileItem(newValue, this.path, this.size, this.modifiedTime, this.displayName);
    }

    public final JWFileItem withPath(Path value) {
        if (this.path == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "path");
        return new JWFileItem(this.kind, newValue, this.size, this.modifiedTime, this.displayName);
    }

    public final JWFileItem withSize(long value) {
        if (this.size == value) {
            return this;
        }
        return new JWFileItem(this.kind, this.path, value, this.modifiedTime, this.displayName);
    }

    public final JWFileItem withModifiedTime(FileTime value) {
        if (this.modifiedTime == value) {
            return this;
        }
        FileTime newValue = Objects.requireNonNull(value, "modifiedTime");
        return new JWFileItem(this.kind, this.path, this.size, newValue, this.displayName);
    }

    public final JWFileItem withDisplayName(String value) {
        String newValue = Objects.requireNonNull(value, "displayName");
        if (Objects.equals(this.displayName, newValue)) {
            return this;
        }
        return new JWFileItem(this.kind, this.path, this.size, this.modifiedTime, newValue);
    }

    public final JWFileItem withDisplayName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.displayName, value)) {
            return this;
        }
        return new JWFileItem(this.kind, this.path, this.size, this.modifiedTime, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JWFileItem && this.equalTo((JWFileItem)another);
    }

    private boolean equalTo(JWFileItem another) {
        return this.kind.equals((Object)another.kind) && this.path.equals(another.path) && this.size == another.size && this.modifiedTime.equals(another.modifiedTime) && Objects.equals(this.displayName, another.displayName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.kind.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + Long.hashCode(this.size);
        h += (h << 5) + this.modifiedTime.hashCode();
        h += (h << 5) + Objects.hashCode(this.displayName);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("JWFileItem{");
        builder.append("kind=").append(this.kind);
        builder.append(", ");
        builder.append("path=").append(this.path);
        builder.append(", ");
        builder.append("size=").append(this.size);
        builder.append(", ");
        builder.append("modifiedTime=").append(this.modifiedTime);
        if (this.displayName != null) {
            builder.append(", ");
            builder.append("displayName=").append(this.displayName);
        }
        return builder.append("}").toString();
    }

    public static JWFileItem copyOf(JWFileItemType instance) {
        if (instance instanceof JWFileItem) {
            return (JWFileItem)instance;
        }
        return JWFileItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_KIND = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private static final long INIT_BIT_SIZE = 4L;
        private static final long INIT_BIT_MODIFIED_TIME = 8L;
        private long initBits = 15L;
        private JWFileKind kind;
        private Path path;
        private long size;
        private FileTime modifiedTime;
        private String displayName;

        private Builder() {
        }

        public final Builder from(JWFileItemType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setKind(instance.kind());
            this.setPath(instance.path());
            this.setSize(instance.size());
            this.setModifiedTime(instance.modifiedTime());
            Optional<String> displayNameOptional = instance.displayName();
            if (displayNameOptional.isPresent()) {
                this.setDisplayName(displayNameOptional);
            }
            return this;
        }

        public final Builder setKind(JWFileKind kind) {
            this.kind = Objects.requireNonNull(kind, "kind");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPath(Path path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setSize(long size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setModifiedTime(FileTime modifiedTime) {
            this.modifiedTime = Objects.requireNonNull(modifiedTime, "modifiedTime");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setDisplayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            return this;
        }

        public final Builder setDisplayName(Optional<String> displayName) {
            this.displayName = displayName.orElse(null);
            return this;
        }

        public JWFileItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new JWFileItem(this.kind, this.path, this.size, this.modifiedTime, this.displayName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("kind");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("modifiedTime");
            }
            return "Cannot build JWFileItem, some of required attributes are not set " + attributes;
        }
    }
}

