/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.junreachable.UnreachableCodeException;
import com.io7m.jwheatsheaf.ui.internal.JWFileItem;
import com.io7m.jwheatsheaf.ui.internal.JWStrings;
import java.util.Objects;
import javafx.scene.control.Tooltip;

public final class JWToolTips {
    private final JWStrings strings;

    JWToolTips(JWStrings inStrings) {
        this.strings = Objects.requireNonNull(inStrings, "strings");
    }

    public Tooltip tooltipOf(JWFileItem item) {
        Objects.requireNonNull(item, "item");
        switch (item.kind()) {
            case REGULAR_FILE: 
            case SYMBOLIC_LINK: 
            case UNKNOWN: {
                return new Tooltip(this.strings.tooltipFile(item.path()));
            }
            case DIRECTORY: {
                return new Tooltip(this.strings.tooltipDirectory(item.path()));
            }
        }
        throw new UnreachableCodeException();
    }
}

