/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jaffirm.core.Preconditions;
import com.io7m.jwheatsheaf.api.JWDirectoryCreationFailed;
import com.io7m.jwheatsheaf.api.JWFileChooserConfiguration;
import com.io7m.jwheatsheaf.api.JWFileChooserEventType;
import com.io7m.jwheatsheaf.api.JWFileChooserFilterType;
import com.io7m.jwheatsheaf.api.JWFileImageSetType;
import com.io7m.jwheatsheaf.api.JWFileListingFailed;
import com.io7m.jwheatsheaf.ui.JWFileChoosers;
import com.io7m.jwheatsheaf.ui.internal.JWFileChooserFilterAllFiles;
import com.io7m.jwheatsheaf.ui.internal.JWFileChooserFilterOnlyDirectories;
import com.io7m.jwheatsheaf.ui.internal.JWFileChoosersTesting;
import com.io7m.jwheatsheaf.ui.internal.JWFileItem;
import com.io7m.jwheatsheaf.ui.internal.JWFileItemTableNameCell;
import com.io7m.jwheatsheaf.ui.internal.JWFileItemTableSizeCell;
import com.io7m.jwheatsheaf.ui.internal.JWFileItemTableTimeCell;
import com.io7m.jwheatsheaf.ui.internal.JWFileItemTableTypeCell;
import com.io7m.jwheatsheaf.ui.internal.JWFileItems;
import com.io7m.jwheatsheaf.ui.internal.JWFileList;
import com.io7m.jwheatsheaf.ui.internal.JWFileListingRetrieverType;
import com.io7m.jwheatsheaf.ui.internal.JWFileSourceEntryFilesystemRoot;
import com.io7m.jwheatsheaf.ui.internal.JWFileSourceEntryRecentItems;
import com.io7m.jwheatsheaf.ui.internal.JWFileSourceEntryType;
import com.io7m.jwheatsheaf.ui.internal.JWImages;
import com.io7m.jwheatsheaf.ui.internal.JWStrings;
import com.io7m.jwheatsheaf.ui.internal.JWToolTips;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Window;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JWFileChooserViewController {
    private static final Logger LOG = LoggerFactory.getLogger(JWFileChooserViewController.class);
    private final AtomicReference<Consumer<JWFileChooserEventType>> eventReceiver;
    private final ChangeListener<Path> listener = this::onPathMenuItemSelected;
    private final BlockingDeque<String> initialFilename;
    private JWFileChooserConfiguration configuration;
    private JWFileChooserFilterType filterAll;
    private JWFileChooserFilterType filterOnlyDirectories;
    private JWFileChoosers choosers;
    private JWFileImageSetType imageSet;
    private JWFileList fileListing;
    private List<Node> lockableViews;
    private List<Path> result = List.of();
    private volatile Path currentDirectory;
    @FXML
    private Button newDirectoryButton;
    @FXML
    private Button okButton;
    @FXML
    private Button selectDirectButton;
    @FXML
    private Button upDirectoryButton;
    @FXML
    private Button homeDirectoryButton;
    @FXML
    private ChoiceBox<Path> pathMenu;
    @FXML
    private ComboBox<JWFileChooserFilterType> fileTypeMenu;
    @FXML
    private ListView<JWFileSourceEntryType> sourcesList;
    @FXML
    private Pane mainContent;
    @FXML
    private ProgressIndicator progressIndicator;
    @FXML
    private TableView<JWFileItem> directoryTable;
    @FXML
    private TextField fileName;
    @FXML
    private TextField searchField;
    private ExecutorService ioExecutor;
    private JWFileChoosersTesting testing;
    private JWStrings strings;
    private JWToolTips toolTips;

    public JWFileChooserViewController() {
        this.initialFilename = new LinkedBlockingDeque<String>();
        this.eventReceiver = new AtomicReference<Consumer<JWFileChooserEventType>>(event -> {});
    }

    private static List<Path> allParentsOf(Path startDirectory) {
        ArrayList<Path> parents = new ArrayList<Path>(startDirectory.getNameCount());
        parents.add(startDirectory);
        for (Path currentDirectory = startDirectory.getParent(); currentDirectory != null; currentDirectory = currentDirectory.getParent()) {
            parents.add(currentDirectory);
        }
        return parents;
    }

    private String formatSize(long size) {
        return this.configuration.fileSizeFormatter().formatSize(size);
    }

    public void setEventReceiver(Consumer<JWFileChooserEventType> newEventReceiver) {
        this.eventReceiver.set(Objects.requireNonNullElse(newEventReceiver, event -> {}));
    }

    public void setConfiguration(JWFileChoosers inChoosers, ExecutorService inIoExecutor, JWFileChoosersTesting inTesting, JWStrings inStrings, JWFileImageSetType inDefaultImageSet, JWFileChooserConfiguration inConfiguration) {
        this.choosers = Objects.requireNonNull(inChoosers, "inChoosers");
        this.configuration = Objects.requireNonNull(inConfiguration, "configuration");
        this.testing = Objects.requireNonNull(inTesting, "inTesting");
        this.strings = Objects.requireNonNull(inStrings, "inStrings");
        this.ioExecutor = Objects.requireNonNull(inIoExecutor, "inIoExecutor");
        Objects.requireNonNull(inDefaultImageSet, "inDefaultImageSet");
        this.toolTips = new JWToolTips(this.strings);
        this.filterAll = JWFileChooserFilterAllFiles.create(this.strings);
        this.filterOnlyDirectories = JWFileChooserFilterOnlyDirectories.create(this.strings);
        this.fileListing = new JWFileList(this.filterAll);
        this.imageSet = this.configuration.fileImageSet().orElse(inDefaultImageSet);
        this.newDirectoryButton.setGraphic((Node)JWImages.imageView16x16Of(this.imageSet.forDirectoryCreate()));
        this.upDirectoryButton.setGraphic((Node)JWImages.imageView16x16Of(this.imageSet.forDirectoryUp()));
        this.selectDirectButton.setGraphic((Node)JWImages.imageView16x16Of(this.imageSet.forSelectDirect()));
        this.homeDirectoryButton.setGraphic((Node)JWImages.imageView16x16Of(this.imageSet.forHome()));
        FileSystem fileSystem = this.configuration.fileSystem();
        Path startDirectory = this.configuration.initialDirectory().orElse(fileSystem.getPath("", new String[0]).toAbsolutePath());
        this.configureButtons();
        this.configureSearch();
        this.configureFileField();
        this.configureTableView();
        this.configureFileTypeMenu();
        this.configureSourceList(fileSystem);
        this.lockableViews = List.of(this.directoryTable, this.homeDirectoryButton, this.newDirectoryButton, this.okButton, this.pathMenu, this.searchField, this.selectDirectButton, this.sourcesList, this.upDirectoryButton);
        this.setCurrentDirectory(startDirectory);
    }

    private void configureSearch() {
        this.searchField.textProperty().addListener(observable -> this.onSearchFieldChanged());
    }

    private void configureFileField() {
        this.fileName.textProperty().addListener(observable -> this.onNameFieldChanged());
        this.configuration.initialFileName().ifPresent(this.initialFilename::push);
    }

    private void configureSourceList(FileSystem fileSystem) {
        ArrayList<JWFileSourceEntryType> sources = new ArrayList<JWFileSourceEntryType>();
        sources.add(new JWFileSourceEntryRecentItems(this.configuration));
        for (Path root : fileSystem.getRootDirectories()) {
            sources.add(new JWFileSourceEntryFilesystemRoot(root));
        }
        this.sourcesList.setItems(FXCollections.observableList(sources));
        this.sourcesList.setCellFactory((Callback)new SourceListCellFactory());
    }

    private void configureFileTypeMenu() {
        Callback cellFactory = param -> {
            ListCell<JWFileChooserFilterType> cell = new ListCell<JWFileChooserFilterType>(){

                protected void updateItem(JWFileChooserFilterType item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty || item == null) {
                        this.setGraphic(null);
                        this.setText(null);
                        return;
                    }
                    this.setText(item.description());
                    this.setGraphic(null);
                }
            };
            return cell;
        };
        this.fileTypeMenu.setCellFactory(cellFactory);
        this.fileTypeMenu.setButtonCell((ListCell)cellFactory.call(null));
        ArrayList<JWFileChooserFilterType> filters = new ArrayList<JWFileChooserFilterType>();
        filters.add(this.filterAll);
        filters.add(this.filterOnlyDirectories);
        filters.addAll(this.configuration.fileFilters());
        this.fileTypeMenu.setItems(FXCollections.observableList(filters));
        this.fileTypeMenu.getSelectionModel().select(0);
    }

    private void setCurrentDirectory(Path path) {
        this.currentDirectory = Objects.requireNonNull(path, "path");
        this.rebuildPathMenu(path);
        this.populateDirectoryTable(path);
    }

    private void rebuildPathMenu(Path startDirectory) {
        List<Path> directories = JWFileChooserViewController.allParentsOf(startDirectory);
        SingleSelectionModel selectionModel = this.pathMenu.getSelectionModel();
        selectionModel.selectedItemProperty().removeListener(this.listener);
        this.pathMenu.setItems(FXCollections.observableList(directories));
        selectionModel.select(0);
        selectionModel.selectedItemProperty().addListener(this.listener);
    }

    private void populateDirectoryTable(Path directory) {
        this.populateDirectoryTableWith(() -> JWFileItems.listDirectory(directory));
    }

    private void populateDirectoryTableWith(JWFileListingRetrieverType itemRetriever) {
        this.directoryTable.setItems(this.fileListing.items());
        this.ioLockUI();
        this.ioExecutor.execute(() -> {
            try {
                List<JWFileItem> items = itemRetriever.onFileItemsRequested();
                this.applyTestingIODelayIfRequested();
                Platform.runLater(() -> {
                    this.ioUnlockUI();
                    this.fileListing.setItems(items);
                    try {
                        String name = (String)this.initialFilename.pop();
                        this.trySelectDirectoryItem(items, name);
                        this.fileName.setText(name);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                });
            }
            catch (Exception e) {
                LOG.error("exception during directory listing: ", (Throwable)e);
                Platform.runLater(() -> {
                    this.ioUnlockUI();
                    this.fileListing.setItems(List.of());
                    try {
                        this.eventReceiver.get().accept((JWFileChooserEventType)JWFileListingFailed.of((Path)this.currentDirectory, (Exception)e));
                    }
                    catch (Exception ex) {
                        LOG.error("exception raised by event receiver: ", (Throwable)ex);
                    }
                });
            }
        });
    }

    private void trySelectDirectoryItem(List<JWFileItem> items, String name) {
        for (JWFileItem item : items) {
            Path itemFileName = item.path().getFileName();
            if (itemFileName == null || !Objects.equals(itemFileName.toString(), name)) continue;
            this.directoryTable.getSelectionModel().select((Object)item);
            return;
        }
    }

    private void ioUnlockUI() {
        Preconditions.checkPreconditionV((boolean)Platform.isFxApplicationThread(), (String)"Must be the FX application thread", (Object[])new Object[0]);
        for (Node view : this.lockableViews) {
            view.setDisable(false);
        }
        this.progressIndicator.setVisible(false);
        this.reconfigureOKButton();
    }

    private void ioLockUI() {
        Preconditions.checkPreconditionV((boolean)Platform.isFxApplicationThread(), (String)"Must be the FX application thread", (Object[])new Object[0]);
        for (Node view : this.lockableViews) {
            view.setDisable(true);
        }
        this.progressIndicator.setVisible(true);
    }

    private void applyTestingIODelayIfRequested() {
        this.testing.ioDelay().ifPresent(duration -> {
            try {
                Thread.sleep(duration.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    private void onPathMenuItemSelected(ObservableValue<? extends Path> observable, Path oldValue, Path newValue) {
        this.setCurrentDirectory(newValue);
    }

    @FXML
    private void onFileFilterSelected() {
        this.fileListing.setFilter((JWFileChooserFilterType)this.fileTypeMenu.getValue());
    }

    @FXML
    private void onSearchFieldChanged() {
        this.fileListing.setSearch(this.searchField.getText().trim());
    }

    @FXML
    private void onSelectDirectButton() {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle(this.strings.enterPathTitle());
        dialog.setHeaderText(null);
        dialog.setContentText(this.strings.enterPath());
        this.configuration.cssStylesheet().ifPresent(css -> dialog.getDialogPane().getStylesheets().add((Object)css.toExternalForm()));
        Optional nameOpt = dialog.showAndWait();
        if (nameOpt.isPresent()) {
            String name = (String)nameOpt.get();
            Path path = this.configuration.fileSystem().getPath(name, new String[0]);
            Path parent = path.getParent();
            if (parent != null) {
                this.setCurrentDirectory(parent);
            }
            this.fileName.setText(path.getFileName().toString());
        }
    }

    @FXML
    private void onUpDirectoryButton() {
        Path parent = this.currentDirectory.getParent();
        if (parent != null) {
            this.setCurrentDirectory(parent);
        }
    }

    @FXML
    private void onCreateDirectoryButton() {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle(this.strings.createDirectoryTitle());
        dialog.setHeaderText(null);
        dialog.setContentText(this.strings.enterDirectoryName());
        this.configuration.cssStylesheet().ifPresent(css -> dialog.getDialogPane().getStylesheets().add((Object)css.toExternalForm()));
        Optional nameOpt = dialog.showAndWait();
        if (nameOpt.isPresent()) {
            String name = (String)nameOpt.get();
            Path newDirectory = this.currentDirectory.resolve(name);
            try {
                Files.createDirectories(newDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOG.error("error creating directory: ", (Throwable)e);
                try {
                    this.eventReceiver.get().accept((JWFileChooserEventType)JWDirectoryCreationFailed.of((Path)newDirectory, (Exception)e));
                }
                catch (Exception ex) {
                    LOG.error("exception raised by event receiver: ", (Throwable)ex);
                }
            }
            this.setCurrentDirectory(this.currentDirectory);
        }
    }

    @FXML
    private void onOKSelected() {
        switch (this.configuration.action()) {
            case OPEN_EXISTING_MULTIPLE: 
            case OPEN_EXISTING_SINGLE: {
                this.result = this.directoryTable.getSelectionModel().getSelectedItems().stream().map(JWFileItem::path).collect(Collectors.toList());
                break;
            }
            case CREATE: {
                this.result = List.of(this.currentDirectory.resolve(this.fileName.getText()));
            }
        }
        Window window = this.mainContent.getScene().getWindow();
        window.hide();
    }

    @FXML
    private void onCancelSelected() {
        this.result = List.of();
        Window window = this.mainContent.getScene().getWindow();
        window.hide();
    }

    @FXML
    private void onHomeSelected() {
        Optional homeDirectoryOpt = this.configuration.homeDirectory();
        homeDirectoryOpt.ifPresent(this::setCurrentDirectory);
    }

    @FXML
    private void onNameFieldChanged() {
        this.reconfigureOKButton();
    }

    private void configureButtons() {
        this.configureButtonHome();
        switch (this.configuration.action()) {
            case OPEN_EXISTING_MULTIPLE: 
            case OPEN_EXISTING_SINGLE: {
                this.okButton.setText(this.strings.open());
                break;
            }
            case CREATE: {
                this.okButton.setText(this.strings.save());
            }
        }
        this.okButton.setDisable(true);
        this.newDirectoryButton.setDisable(!this.configuration.allowDirectoryCreation());
        TableView.TableViewSelectionModel selectionModel = this.directoryTable.getSelectionModel();
        selectionModel.selectedItemProperty().addListener(item -> this.reconfigureOKButton());
    }

    private void configureButtonHome() {
        Parent homeParent = this.homeDirectoryButton.getParent();
        Optional homeDirectoryOpt = this.configuration.homeDirectory();
        if (homeDirectoryOpt.isEmpty()) {
            homeParent.setVisible(false);
            homeParent.setManaged(false);
        }
    }

    private void configureTableView() {
        TableView.TableViewSelectionModel selectionModel = this.directoryTable.getSelectionModel();
        switch (this.configuration.action()) {
            case OPEN_EXISTING_SINGLE: 
            case CREATE: {
                selectionModel.setSelectionMode(SelectionMode.SINGLE);
                break;
            }
            case OPEN_EXISTING_MULTIPLE: {
                selectionModel.setSelectionMode(SelectionMode.MULTIPLE);
            }
        }
        this.directoryTable.setPlaceholder((Node)new Label(""));
        ObservableList tableColumns = this.directoryTable.getColumns();
        TableColumn tableTypeColumn = (TableColumn)tableColumns.get(0);
        TableColumn tableNameColumn = (TableColumn)tableColumns.get(1);
        TableColumn tableSizeColumn = (TableColumn)tableColumns.get(2);
        TableColumn tableTimeColumn = (TableColumn)tableColumns.get(3);
        tableTypeColumn.setSortable(true);
        tableTypeColumn.setReorderable(false);
        tableTypeColumn.setCellFactory(column -> {
            JWFileItemTableTypeCell cell = new JWFileItemTableTypeCell(this.imageSet, this.toolTips);
            cell.setOnMouseClicked(this::onTableRowClicked);
            return cell;
        });
        tableNameColumn.setSortable(true);
        tableNameColumn.setReorderable(false);
        tableNameColumn.setCellFactory(column -> {
            JWFileItemTableNameCell cell = new JWFileItemTableNameCell(this.toolTips);
            cell.setOnMouseClicked(this::onTableRowClicked);
            return cell;
        });
        tableSizeColumn.setSortable(true);
        tableSizeColumn.setReorderable(false);
        tableSizeColumn.setCellFactory(column -> {
            JWFileItemTableSizeCell cell = new JWFileItemTableSizeCell(this::formatSize);
            cell.setOnMouseClicked(this::onTableRowClicked);
            return cell;
        });
        tableTimeColumn.setSortable(true);
        tableTimeColumn.setReorderable(false);
        tableTimeColumn.setCellFactory(column -> {
            JWFileItemTableTimeCell cell = new JWFileItemTableTimeCell(this.configuration.fileTimeFormatter());
            cell.setOnMouseClicked(this::onTableRowClicked);
            return cell;
        });
        tableTypeColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((JWFileItem)param.getValue())));
        tableNameColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((JWFileItem)param.getValue())));
        tableSizeColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((JWFileItem)param.getValue()).size()));
        tableTimeColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((JWFileItem)param.getValue()).modifiedTime()));
        this.fileListing.comparator().bind((ObservableValue)this.directoryTable.comparatorProperty());
    }

    private void reconfigureOKButton() {
        boolean enabled = false;
        switch (this.configuration.action()) {
            case OPEN_EXISTING_MULTIPLE: 
            case OPEN_EXISTING_SINGLE: {
                enabled = this.atLeastOneItemSelected();
                break;
            }
            case CREATE: {
                enabled = this.atLeastOneItemSelected() || this.fileNameNotEmpty();
            }
        }
        this.okButton.setDisable(!enabled);
    }

    private boolean fileNameNotEmpty() {
        return !this.fileName.getText().isEmpty();
    }

    private boolean atLeastOneItemSelected() {
        return this.directoryTable.getSelectionModel().getSelectedItems().size() >= 1;
    }

    private void onTableRowClicked(MouseEvent event) {
        Path directory;
        TableView.TableViewSelectionModel selectionModel;
        JWFileItem item;
        if (event.getClickCount() == 1) {
            TableView.TableViewSelectionModel selectionModel2 = this.directoryTable.getSelectionModel();
            JWFileItem item2 = (JWFileItem)selectionModel2.getSelectedItem();
            if (item2 != null) {
                this.fileName.setText(item2.name());
            }
            return;
        }
        if (event.getClickCount() == 2 && (item = (JWFileItem)(selectionModel = this.directoryTable.getSelectionModel()).getSelectedItem()) != null && Files.isDirectory(directory = item.path(), new LinkOption[0])) {
            this.setCurrentDirectory(directory);
        }
    }

    private void onSourceItemDoubleClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            JWFileSourceEntryType item = (JWFileSourceEntryType)this.sourcesList.getSelectionModel().getSelectedItem();
            item.path().ifPresent(this::setCurrentDirectory);
            this.populateDirectoryTableWith(item);
        }
    }

    public List<Path> result() {
        return this.result;
    }

    private final class JWFileSourceEntryTypeListCell
    extends ListCell<JWFileSourceEntryType> {
        JWFileSourceEntryTypeListCell() {
        }

        protected void updateItem(JWFileSourceEntryType item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            item.onListCell(JWFileChooserViewController.this.imageSet, JWFileChooserViewController.this.strings, this);
        }
    }

    private final class SourceListCellFactory
    implements Callback<ListView<JWFileSourceEntryType>, ListCell<JWFileSourceEntryType>> {
        SourceListCellFactory() {
        }

        public ListCell<JWFileSourceEntryType> call(ListView<JWFileSourceEntryType> param) {
            JWFileSourceEntryTypeListCell cell = new JWFileSourceEntryTypeListCell();
            cell.setOnMouseClicked(x$0 -> JWFileChooserViewController.this.onSourceItemDoubleClicked((MouseEvent)x$0));
            return cell;
        }
    }
}

