/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jwheatsheaf.api.JWFileKind;
import com.io7m.jwheatsheaf.ui.internal.JWFileItem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JWFileItems {
    private static final Logger LOG = LoggerFactory.getLogger(JWFileItems.class);

    private JWFileItems() {
    }

    public static List<JWFileItem> listDirectory(Path directory) throws IOException {
        ArrayList<JWFileItem> items = new ArrayList<JWFileItem>(32);
        items.add(JWFileItems.resolveFileItem(directory).withDisplayName("."));
        try (Stream<Path> stream = Files.list(directory);){
            stream.sorted().forEach(path -> items.add(JWFileItems.resolveFileItem(path)));
        }
        return items;
    }

    public static JWFileItem resolveFileItem(Path path) {
        Objects.requireNonNull(path, "path");
        try {
            return JWFileItem.builder().setKind(JWFileItems.fileKind(path)).setModifiedTime(JWFileItems.fileTime(path)).setSize(JWFileItems.fileSize(path)).setPath(path).build();
        }
        catch (IOException e) {
            LOG.error("i/o exception during directory listing: ", (Throwable)e);
            return JWFileItem.builder().setKind(JWFileKind.UNKNOWN).setModifiedTime(FileTime.fromMillis(0L)).setSize(0L).setPath(path).build();
        }
    }

    private static long fileSize(Path path) throws IOException {
        return Files.size(path);
    }

    private static FileTime fileTime(Path path) throws IOException {
        return Files.getLastModifiedTime(path, new LinkOption[0]);
    }

    private static JWFileKind fileKind(Path path) {
        if (Files.isSymbolicLink(path)) {
            return JWFileKind.SYMBOLIC_LINK;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return JWFileKind.DIRECTORY;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return JWFileKind.REGULAR_FILE;
        }
        return JWFileKind.UNKNOWN;
    }
}

