/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jaffirm.core.Preconditions;
import com.io7m.jwheatsheaf.api.JWFileChooserConfiguration;
import com.io7m.jwheatsheaf.api.JWFileImageSetType;
import com.io7m.jwheatsheaf.ui.internal.JWFileItem;
import com.io7m.jwheatsheaf.ui.internal.JWFileItems;
import com.io7m.jwheatsheaf.ui.internal.JWFileSourceEntryType;
import com.io7m.jwheatsheaf.ui.internal.JWImages;
import com.io7m.jwheatsheaf.ui.internal.JWStrings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ListCell;

public final class JWFileSourceEntryRecentItems
implements JWFileSourceEntryType {
    private final JWFileChooserConfiguration configuration;

    public JWFileSourceEntryRecentItems(JWFileChooserConfiguration inConfiguration) {
        this.configuration = Objects.requireNonNull(inConfiguration, "configuration");
    }

    @Override
    public void onListCell(JWFileImageSetType images, JWStrings strings, ListCell<JWFileSourceEntryType> cell) {
        Preconditions.checkPreconditionV((boolean)Platform.isFxApplicationThread(), (String)"Must be FX application thread", (Object[])new Object[0]);
        cell.setText(strings.recentItems());
        cell.setGraphic((Node)JWImages.imageView16x16Of(images.forRecentItems()));
    }

    @Override
    public Optional<Path> path() {
        return Optional.empty();
    }

    @Override
    public List<JWFileItem> onFileItemsRequested() {
        Preconditions.checkPreconditionV((!Platform.isFxApplicationThread() ? 1 : 0) != 0, (String)"Must not be FX application thread", (Object[])new Object[0]);
        List paths = this.configuration.recentFiles().stream().sorted().collect(Collectors.toList());
        ArrayList<JWFileItem> items = new ArrayList<JWFileItem>(paths.size());
        for (Path path : paths) {
            items.add(JWFileItems.resolveFileItem(path));
        }
        return items;
    }
}

