/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jwheatsheaf.api.JWFileImageSetType;
import com.io7m.jwheatsheaf.api.JWFileKind;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public final class JWImages {
    private JWImages() {
    }

    public static ImageView imageView16x16Of(URL url) {
        Objects.requireNonNull(url, "url");
        ImageView imageView = new ImageView();
        imageView.setFitWidth(16.0);
        imageView.setFitHeight(16.0);
        imageView.setImage(new Image(url.toString()));
        return imageView;
    }

    public static ImageView imageOfKind(JWFileImageSetType images, JWFileKind kind) {
        Optional imageOpt = images.forFileKind(kind);
        if (imageOpt.isPresent()) {
            ImageView imageView = new ImageView();
            imageView.setFitWidth(16.0);
            imageView.setFitHeight(16.0);
            imageView.setImage(new Image(((URL)imageOpt.get()).toString()));
            return imageView;
        }
        return null;
    }
}

