/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class JWStrings {
    private final ResourceBundle resourceBundle;

    private JWStrings(ResourceBundle inResourceBundle) {
        this.resourceBundle = inResourceBundle;
    }

    public static ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("com.io7m.jwheatsheaf.ui.internal.Strings", locale);
    }

    public static ResourceBundle getResourceBundle() {
        return JWStrings.getResourceBundle(Locale.getDefault());
    }

    public static JWStrings of(ResourceBundle bundle) {
        return new JWStrings(bundle);
    }

    private String format(String idId, Object ... inArgs) {
        return MessageFormat.format(this.resourceBundle.getString(idId), inArgs);
    }

    public String createDirectoryTitle() {
        return this.resourceBundle.getString("ui.directoryCreateTitle");
    }

    public String recentItems() {
        return this.resourceBundle.getString("ui.recentItems");
    }

    public String filterAllFilesDescription() {
        return this.resourceBundle.getString("ui.filterAllFilesDescription");
    }

    public String filterOnlyDirectoriesDescription() {
        return this.resourceBundle.getString("ui.filterOnlyDirectoriesDescription");
    }

    public String enterDirectoryName() {
        return this.resourceBundle.getString("ui.directoryName");
    }

    public String fileSelect() {
        return this.resourceBundle.getString("ui.fileSelect");
    }

    public String filesSelect() {
        return this.resourceBundle.getString("ui.filesSelect");
    }

    public String open() {
        return this.resourceBundle.getString("ui.open");
    }

    public String save() {
        return this.resourceBundle.getString("ui.save");
    }

    public String enterPathTitle() {
        return this.resourceBundle.getString("ui.enterPathTitle");
    }

    public String enterPath() {
        return this.resourceBundle.getString("ui.enterPath");
    }

    public String tooltipDirectory(Path path) {
        return this.format("ui.tooltip.directory", path.toAbsolutePath());
    }

    public String tooltipFile(Path path) {
        return this.format("ui.tooltip.file", path.toAbsolutePath());
    }
}

