/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes;

import com.whitemagicsoftware.keenquotes.Contractions;
import com.whitemagicsoftware.keenquotes.Lexeme;
import com.whitemagicsoftware.keenquotes.Parser;
import com.whitemagicsoftware.keenquotes.ParserFactory;
import com.whitemagicsoftware.keenquotes.Token;
import com.whitemagicsoftware.keenquotes.TokenType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class Converter
implements Function<String, String> {
    public static final Map<TokenType, String> ENTITIES = Map.of(TokenType.QUOTE_OPENING_SINGLE, "&lsquo;", TokenType.QUOTE_CLOSING_SINGLE, "&rsquo;", TokenType.QUOTE_OPENING_DOUBLE, "&ldquo;", TokenType.QUOTE_CLOSING_DOUBLE, "&rdquo;", TokenType.QUOTE_STRAIGHT_SINGLE, "'", TokenType.QUOTE_STRAIGHT_DOUBLE, "\"", TokenType.QUOTE_APOSTROPHE, "&apos;", TokenType.QUOTE_PRIME_SINGLE, "&prime;", TokenType.QUOTE_PRIME_DOUBLE, "&Prime;");
    public static final Map<TokenType, String> CHARS = Map.of(TokenType.QUOTE_OPENING_SINGLE, "\u2018", TokenType.QUOTE_CLOSING_SINGLE, "\u2019", TokenType.QUOTE_OPENING_DOUBLE, "\u201c", TokenType.QUOTE_CLOSING_DOUBLE, "\u201d", TokenType.QUOTE_STRAIGHT_SINGLE, "'", TokenType.QUOTE_STRAIGHT_DOUBLE, "\"", TokenType.QUOTE_APOSTROPHE, "\u2019", TokenType.QUOTE_PRIME_SINGLE, "\u2032", TokenType.QUOTE_PRIME_DOUBLE, "\u2033");
    private final Consumer<Lexeme> mUnresolved;
    private final Contractions mContractions;
    private final Map<TokenType, String> mReplacements;
    private final ParserFactory mFactory;

    public Converter(Consumer<Lexeme> unresolved, ParserFactory.ParserType parserType) {
        this(unresolved, new Contractions.Builder().build(), parserType);
    }

    public Converter(Consumer<Lexeme> unresolved, Map<TokenType, String> replacements, ParserFactory.ParserType parserType) {
        this(unresolved, new Contractions.Builder().build(), replacements, parserType);
    }

    public Converter(Consumer<Lexeme> unresolved, Contractions c, ParserFactory.ParserType parserType) {
        this(unresolved, c, ENTITIES, parserType);
    }

    public Converter(Consumer<Lexeme> unresolved, Contractions c, Map<TokenType, String> replacements, ParserFactory.ParserType parserType) {
        this.mUnresolved = unresolved;
        this.mContractions = c;
        this.mReplacements = replacements;
        this.mFactory = new ParserFactory(parserType);
    }

    @Override
    public String apply(String text) {
        Parser parser = this.mFactory.createParser(text, this.mContractions);
        ArrayList tokens = new ArrayList();
        parser.parse(tokens::add, this.mUnresolved);
        Collections.sort(tokens);
        StringBuilder result = new StringBuilder(text.length());
        int position = 0;
        for (Token token : tokens) {
            if (position <= token.began()) {
                result.append(text, position, token.began());
                result.append(this.mReplacements.get((Object)token.getType()));
            }
            position = token.ended();
        }
        return result.append(text.substring(position)).toString();
    }
}

