/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public abstract class FilteringTokenFilter
extends TokenFilter {
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private int skippedPositions;

    /*
     * WARNING - void declaration
     */
    public FilteringTokenFilter(TokenStream in) {
        super((TokenStream)var1_1);
        void var1_1;
    }

    protected abstract boolean accept() throws IOException;

    @Override
    public final boolean incrementToken() throws IOException {
        this.skippedPositions = 0;
        while (this.input.incrementToken()) {
            if (this.accept()) {
                if (this.skippedPositions != 0) {
                    this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
                }
                return true;
            }
            this.skippedPositions += this.posIncrAtt.getPositionIncrement();
        }
        return false;
    }

    @Override
    public final void reset() throws IOException {
        super.reset();
        this.skippedPositions = 0;
    }

    @Override
    public final void end() throws IOException {
        super.end();
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }
}

