/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.analysis.cn.smart.AnalyzerProfile;
import org.apache.lucene.analysis.cn.smart.hhmm.AbstractDictionary;

final class BigramDictionary
extends AbstractDictionary {
    private static BigramDictionary singleInstance;
    private long[] bigramHashTable;
    private int[] frequencyTable;
    private int max = 0;

    private BigramDictionary() {
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized BigramDictionary getInstance() {
        if (singleInstance == null) {
            singleInstance = new BigramDictionary();
            try {
                BigramDictionary bigramDictionary = singleInstance;
                InputStream inputStream = bigramDictionary.getClass().getResourceAsStream("bigramdict.mem");
                bigramDictionary.loadFromInputStream(inputStream);
            }
            catch (IOException e) {
                Object dictRoot = AnalyzerProfile.ANALYSIS_DATA_DIR;
                try {
                    Object object = dictRoot;
                    dictRoot = singleInstance;
                    Object object2 = (String)object + "/bigramdict.dct";
                    object = Paths.get((String)object + "/bigramdict.mem", new String[0]);
                    if (Files.exists((Path)object, new LinkOption[0])) {
                        ((BigramDictionary)dictRoot).loadFromObj((Path)object);
                    }
                    try {
                        ((BigramDictionary)dictRoot).bigramHashTable = new long[402137];
                        ((BigramDictionary)dictRoot).frequencyTable = new int[402137];
                        for (int i = 0; i < 402137; ++i) {
                            ((BigramDictionary)dictRoot).bigramHashTable[i] = 0L;
                            ((BigramDictionary)dictRoot).frequencyTable[i] = 0;
                        }
                        String string = object2;
                        object2 = dictRoot;
                        int[] nArray = new int[3];
                        byte[] byArray = new byte[4];
                        DataInputStream dataInputStream = new DataInputStream(Files.newInputStream(Paths.get(string, new String[0]), new OpenOption[0]));
                        for (int i = 1410; i < 8178; ++i) {
                            String string2 = BigramDictionary.getCCByGB2312Id(i);
                            dataInputStream.read(byArray);
                            int n = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
                            if (n <= 0) continue;
                            for (int j = 0; j < n; ++j) {
                                dataInputStream.read(byArray);
                                nArray[0] = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
                                dataInputStream.read(byArray);
                                nArray[1] = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
                                dataInputStream.read(byArray);
                                int n2 = nArray[1];
                                if (n2 <= 0) continue;
                                Object object3 = new byte[n2];
                                dataInputStream.read((byte[])object3);
                                object3 = new String((byte[])object3, "GB2312");
                                if (i != 5165) {
                                    object3 = string2 + (String)object3;
                                }
                                char[] cArray = object3.toCharArray();
                                object3 = cArray;
                                long l = BigramDictionary.hash1(cArray);
                                n2 = ((BigramDictionary)object2).getAvaliableIndex(l, (char[])object3);
                                if (n2 == -1) continue;
                                if (((BigramDictionary)object2).bigramHashTable[n2] == 0L) {
                                    ((BigramDictionary)object2).bigramHashTable[n2] = l;
                                }
                                int n3 = n2;
                                ((BigramDictionary)object2).frequencyTable[n3] = ((BigramDictionary)object2).frequencyTable[n3] + nArray[0];
                            }
                        }
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.getMessage());
                    }
                    ((BigramDictionary)dictRoot).saveToObj((Path)object);
                }
                catch (IOException ioe) {
                    void var1_3;
                    RuntimeException ex = new RuntimeException(ioe);
                    ex.addSuppressed(e);
                    throw var1_3;
                }
            }
            catch (ClassNotFoundException e) {
                void var0_7;
                throw new RuntimeException((Throwable)var0_7);
            }
        }
        return singleInstance;
    }

    /*
     * WARNING - void declaration
     */
    private boolean loadFromObj(Path serialObj) {
        try {
            this.loadFromInputStream(Files.newInputStream(serialObj, new OpenOption[0]));
            return true;
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadFromInputStream(InputStream serialObjectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream input = new ObjectInputStream(serialObjectInputStream);
        try {
            this.bigramHashTable = (long[])input.readObject();
            this.frequencyTable = (int[])input.readObject();
        }
        catch (Throwable throwable) {
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        input.close();
    }

    /*
     * WARNING - void declaration
     */
    private void saveToObj(Path serialObj) throws IOException {
        ObjectOutputStream output = new ObjectOutputStream(Files.newOutputStream(serialObj, new OpenOption[0]));
        try {
            output.writeObject(this.bigramHashTable);
            output.writeObject(this.frequencyTable);
        }
        catch (Throwable throwable) {
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        output.close();
    }

    /*
     * WARNING - void declaration
     */
    private int getAvaliableIndex(long hashId, char[] carray) {
        void var1_1;
        int i;
        int hash1 = (int)(hashId % 402137L);
        int hash2 = BigramDictionary.hash2(carray) % 402137;
        if (hash1 < 0) {
            hash1 += 402137;
        }
        if (hash2 < 0) {
            hash2 += 402137;
        }
        int index = hash1;
        for (i = 1; this.bigramHashTable[index] != 0L && this.bigramHashTable[index] != hashId && i < 402137; ++i) {
            index = (hash1 + i * hash2) % 402137;
        }
        if (i < 402137 && (this.bigramHashTable[index] == 0L || this.bigramHashTable[index] == var1_1)) {
            return index;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getFrequency(char[] carray) {
        char[] cArray = carray;
        carray = this;
        long l = BigramDictionary.hash1(cArray);
        int n = (int)(l % 402137L);
        int n2 = BigramDictionary.hash2(cArray) % 402137;
        if (n < 0) {
            n += 402137;
        }
        if (n2 < 0) {
            n2 += 402137;
        }
        int n3 = n;
        int n4 = 1;
        while (carray.bigramHashTable[n3] != 0L && carray.bigramHashTable[n3] != l && n4 < 402137) {
            n3 = (n + n4 * n2) % 402137;
            if (++n4 <= carray.max) continue;
            carray.max = n4;
        }
        int index = n4 < 402137 && carray.bigramHashTable[n3] == l ? n3 : -1;
        if (index != -1) {
            void var1_2;
            return this.frequencyTable[var1_2];
        }
        return 0;
    }
}

