/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.Constants;
import org.apache.lucene.util.RamUsageEstimator;

public final class ArrayUtil {
    private static int MAX_ARRAY_LENGTH = Integer.MAX_VALUE - RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;

    private ArrayUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static int oversize(int minTargetSize, int bytesPerElement) {
        int n;
        void var1_1;
        void var2_2;
        int newSize;
        if (minTargetSize < 0) {
            throw new IllegalArgumentException("invalid array size " + minTargetSize);
        }
        if (minTargetSize == 0) {
            return 0;
        }
        if (minTargetSize > MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("requested array size " + minTargetSize + " exceeds maximum array in java (" + MAX_ARRAY_LENGTH + ")");
        }
        int extra = minTargetSize >> 3;
        if (extra < 3) {
            extra = 3;
        }
        if ((newSize = minTargetSize + var2_2) + 7 < 0 || newSize + 7 > MAX_ARRAY_LENGTH) {
            return MAX_ARRAY_LENGTH;
        }
        if (Constants.JRE_IS_64BIT) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return newSize + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return newSize + 7 & 0x7FFFFFF8;
                }
            }
            return newSize;
        }
        switch (var1_1) {
            case 2: {
                return newSize + 1 & 0x7FFFFFFE;
            }
            case 1: {
                return newSize + 3 & 0x7FFFFFFC;
            }
        }
        return n;
    }

    public static int[] grow(int[] array, int minSize) {
        int[] nArray;
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            int n;
            n = ArrayUtil.oversize(n, 4);
            int[] nArray2 = new int[n];
            System.arraycopy(array, 0, nArray2, 0, array.length);
            return nArray2;
        }
        return nArray;
    }

    public static int[] grow(int[] array) {
        int[] nArray;
        return ArrayUtil.grow(array, 1 + nArray.length);
    }

    public static byte[] grow(byte[] array, int minSize) {
        byte[] byArray;
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            int n;
            n = ArrayUtil.oversize(n, 1);
            byte[] byArray2 = new byte[n];
            System.arraycopy(array, 0, byArray2, 0, array.length);
            return byArray2;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static int hashCode(char[] array, int start, int end) {
        void var1_1;
        int code = 0;
        for (int i = end - 1; i >= 0; --i) {
            code = code * 31 + array[i];
        }
        return (int)var1_1;
    }
}

