/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.CharFont;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.atoms.CharSymbolAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.CharBox;
import com.whitemagicsoftware.tex.exceptions.InvalidSymbolTypeException;
import com.whitemagicsoftware.tex.exceptions.SymbolNotFoundException;
import com.whitemagicsoftware.tex.parsers.TeXSymbolParser;
import java.util.BitSet;
import java.util.Map;

public class SymbolAtom
extends CharSymbolAtom {
    private static final BitSet validSymbolTypes = new BitSet(16);
    private static final Map<String, SymbolAtom> symbols;
    private final String name;
    private final boolean delimiter;

    /*
     * WARNING - void declaration
     */
    public SymbolAtom(SymbolAtom symbolAtom, int type) throws InvalidSymbolTypeException {
        this(symbolAtom.name, (int)var2_2, var1_1.delimiter);
        void var1_1;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public SymbolAtom(String name, int type, boolean delimiter) throws InvalidSymbolTypeException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!validSymbolTypes.get(type)) {
            throw new InvalidSymbolTypeException("The symbol type was not valid! Use one of the symbol type constants from the class 'TeXConstants'.");
        }
        this.name = var1_1;
        this.type = var2_2;
        this.delimiter = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static SymbolAtom get(String name) throws SymbolNotFoundException {
        void var1_1;
        SymbolAtom obj = SymbolAtom.getNullable(name);
        if (obj == null) {
            String string;
            throw new SymbolNotFoundException(string);
        }
        return var1_1;
    }

    public static SymbolAtom getNullable(String name) {
        String string;
        return symbols.get(string);
    }

    public boolean isDelimiter() {
        return this.delimiter;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Box createBox(TeXEnvironment env) {
        void var1_2;
        void var2_3;
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        return new CharBox(var2_3.getChar(this.name, (int)var1_2));
    }

    @Override
    public CharFont getCharFont(TeXFont tf) {
        return tf.getChar(this.name, 0).getCharFont();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "', type=" + this.type + ", delimiter=" + this.delimiter + "}";
    }

    static {
        validSymbolTypes.set(0);
        validSymbolTypes.set(1);
        validSymbolTypes.set(2);
        validSymbolTypes.set(3);
        validSymbolTypes.set(4);
        validSymbolTypes.set(5);
        validSymbolTypes.set(6);
        validSymbolTypes.set(10);
        symbols = new TeXSymbolParser().readSymbols();
    }
}

