/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.parsers;

import com.whitemagicsoftware.tex.exceptions.ResourceParseException;
import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import com.whitemagicsoftware.tex.resources.XMLResourceReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom2.Element;

public class TeXFormulaSettingsParser {
    public static final String RESOURCE_NAME = "TeXFormulaSettings.xml";
    public static final String CHAR_MAPPING_EL = "Map";
    private final Element root = new XMLResourceReader("TeXFormulaSettings.xml").read();

    /*
     * WARNING - void declaration
     */
    public String[] parseSymbolMappings() throws ResourceParseException {
        void var1_1;
        String[] mappings = new String[256];
        Element symbols = this.root.getChild("CharacterToSymbolMappings");
        if (symbols != null) {
            void var2_2;
            TeXFormulaSettingsParser.addToMap(var2_2.getChildren(CHAR_MAPPING_EL), mappings);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String[] parseDelimiterMappings() throws ResourceParseException {
        void var1_1;
        String[] mappings = new String[256];
        Element delimiters = this.root.getChild("CharacterToDelimiterMappings");
        if (delimiters != null) {
            void var2_2;
            TeXFormulaSettingsParser.addToMap(var2_2.getChildren(CHAR_MAPPING_EL), mappings);
        }
        return var1_1;
    }

    private static void addToMap(List<Element> mapList, String[] table) throws ResourceParseException {
        for (Object e : mapList) {
            Element e2 = (Element)e;
            String ch = e2.getAttributeValue("char");
            String symbol = e2.getAttributeValue("symbol");
            if (ch == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, e2.getName(), "char", null);
            }
            if (symbol == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, e2.getName(), "symbol", null);
            }
            if (ch.length() == 1) {
                table[var3_4.charAt((int)0)] = symbol;
                continue;
            }
            throw new XMLResourceParseException(RESOURCE_NAME, e2.getName(), "char", "must have a value that contains exactly 1 character!");
        }
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> parseTextStyles() throws ResourceParseException {
        void var1_1;
        HashSet<String> res = new HashSet<String>();
        Element textStyles = this.root.getChild("TextStyles");
        if (textStyles != null) {
            Iterator<Element> iterator;
            for (Element style : ((Element)((Object)iterator)).getChildren("TextStyle")) {
                String name = style.getAttributeValue("name");
                if (name == null) {
                    void var3_3;
                    throw new XMLResourceParseException(RESOURCE_NAME, var3_3.getName(), "name", null);
                }
                res.add(name);
            }
        }
        return var1_1;
    }
}

