/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.parsers;

import com.whitemagicsoftware.tex.atoms.SymbolAtom;
import com.whitemagicsoftware.tex.exceptions.ResourceParseException;
import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import com.whitemagicsoftware.tex.resources.XMLResourceReader;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Element;

public class TeXSymbolParser {
    public static final String RESOURCE_NAME = "TeXSymbols.xml";
    public static final String DELIMITER_ATTR = "del";
    public static final String TYPE_ATTR = "type";
    private static final Map<String, Integer> typeMappings = new HashMap<String, Integer>();
    private final Element root = new XMLResourceReader("TeXSymbols.xml").read();

    /*
     * WARNING - void declaration
     */
    public Map<String, SymbolAtom> readSymbols() throws ResourceParseException {
        void var1_1;
        HashMap<String, SymbolAtom> res = new HashMap<String, SymbolAtom>();
        for (Element symbol : this.root.getChildren("Symbol")) {
            void var3_3;
            String type = TeXSymbolParser.getAttrValueAndCheckIfNotNull(TYPE_ATTR, symbol);
            Integer typeVal = typeMappings.get(type);
            if (typeVal == null) {
                String msg = String.format("has an unknown value '%s'", type);
                throw new XMLResourceParseException(RESOURCE_NAME, "Symbol", TYPE_ATTR, msg);
            }
            String name = TeXSymbolParser.getAttrValueAndCheckIfNotNull("name", symbol);
            String del = symbol.getAttributeValue(DELIMITER_ATTR);
            boolean delimiter = "true".equals(del);
            res.put(name, new SymbolAtom(name, typeVal, (boolean)var3_3));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String getAttrValueAndCheckIfNotNull(String attrName, Element element) throws ResourceParseException {
        void var2_2;
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            String string;
            void var1_1;
            throw new XMLResourceParseException(RESOURCE_NAME, var1_1.getName(), string, null);
        }
        return var2_2;
    }

    static {
        typeMappings.put("ord", 0);
        typeMappings.put("op", 1);
        typeMappings.put("bin", 2);
        typeMappings.put("rel", 3);
        typeMappings.put("open", 4);
        typeMappings.put("close", 5);
        typeMappings.put("punct", 6);
        typeMappings.put("acc", 10);
    }
}

