/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.RandomAccess;
import org.jdom2.Attribute;
import org.jdom2.ContentList;
import org.jdom2.Element;
import org.jdom2.IllegalAddException;
import org.jdom2.Namespace;
import org.jdom2.Verifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AttributeList
extends AbstractList<Attribute>
implements RandomAccess {
    private Attribute[] attributeData;
    private int size;
    private final Element parent;
    private static final Comparator<Attribute> ATTRIBUTE_NATURAL = new Comparator<Attribute>(){};

    /*
     * WARNING - void declaration
     */
    AttributeList(Element parent) {
        void var1_1;
        this.parent = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(Attribute attribute) {
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        if (Verifier.checkNamespaceCollision(attribute, this.parent) != null) {
            Attribute attribute2 = attribute;
            throw new IllegalAddException(this.parent, attribute2, Verifier.checkNamespaceCollision(attribute2, this.parent));
        }
        int duplicate = this.indexOfDuplicate(attribute);
        if (duplicate < 0) {
            attribute.setParent(this.parent);
            AttributeList attributeList = this;
            attributeList.ensureCapacity(attributeList.size + 1);
            this.attributeData[this.size++] = attribute;
            ++this.modCount;
        } else {
            void var1_1;
            Attribute attribute3 = this.attributeData[duplicate];
            attribute3.setParent(null);
            this.attributeData[var2_2] = attribute;
            var1_1.setParent(this.parent);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private void add(int index, Attribute attribute) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        int n = this.indexOfDuplicate(attribute);
        if (n >= 0) {
            throw new IllegalAddException("Cannot add duplicate attribute");
        }
        String reason = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (reason != null) {
            void var3_4;
            throw new IllegalAddException(this.parent, attribute, (String)var3_4);
        }
        attribute.setParent(this.parent);
        AttributeList attributeList = this;
        attributeList.ensureCapacity(attributeList.size + 1);
        if (index == this.size) {
            this.attributeData[this.size++] = attribute;
        } else {
            void var2_2;
            System.arraycopy(this.attributeData, index, this.attributeData, index + 1, this.size - index);
            this.attributeData[var1_1] = var2_2;
            ++this.size;
        }
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends Attribute> collection) {
        void var1_1;
        AttributeList attributeList = this;
        return attributeList.addAll(attributeList.size(), (Collection<? extends Attribute>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(int index, Collection<? extends Attribute> collection) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        if (collection == null) {
            throw new NullPointerException("Can not add a null Collection to AttributeList");
        }
        int addcnt = collection.size();
        if (addcnt == 0) {
            return false;
        }
        if (addcnt == 1) {
            this.add(index, collection.iterator().next());
            return true;
        }
        AttributeList attributeList = this;
        attributeList.ensureCapacity(attributeList.size() + addcnt);
        int tmpmodcount = this.modCount;
        int count = 0;
        try {
            for (Attribute attribute : collection) {
                this.add(index + count, attribute);
                ++count;
            }
        }
        catch (Throwable throwable) {
            void var3_4;
            while (--count >= 0) {
                this.remove(index + count);
            }
            this.modCount = var3_4;
            throw throwable;
        }
        return true;
    }

    @Override
    public final void clear() {
        if (this.attributeData != null) {
            while (this.size > 0) {
                --this.size;
                this.attributeData[this.size].setParent(null);
                this.attributeData[this.size] = null;
            }
        }
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureCapacity(int minCapacity) {
        void var1_1;
        if (this.attributeData == null) {
            this.attributeData = new Attribute[Math.max(minCapacity, 4)];
            return;
        }
        if (minCapacity < this.attributeData.length) {
            return;
        }
        this.attributeData = ContentList.1.copyOf(this.attributeData, (int)(var1_1 + 4 >>> 1 << 1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Attribute get(int index) {
        void var1_1;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        return this.attributeData[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    final Attribute get(String name, Namespace namespace) {
        void var1_2;
        void var2_3;
        int index = this.indexOf(name, (Namespace)var2_3);
        if (index < 0) {
            return null;
        }
        return this.attributeData[var1_2];
    }

    private int indexOf(String name, Namespace namespace) {
        while (this.attributeData != null) {
            if (namespace == null) {
                namespace = Namespace.NO_NAMESPACE;
                continue;
            }
            String uri = namespace.getURI();
            for (int i = 0; i < this.size; ++i) {
                Attribute att = this.attributeData[i];
                if (!uri.equals(att.getNamespaceURI()) || !name.equals(att.getName())) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Attribute remove(int index) {
        void var2_2;
        void var1_1;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        Attribute old = this.attributeData[index];
        old.setParent(null);
        System.arraycopy(this.attributeData, index + 1, this.attributeData, index, this.size - var1_1 - 1);
        this.attributeData[--this.size] = null;
        ++this.modCount;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int indexOfDuplicate(Attribute attribute) {
        void var1_1;
        return this.indexOf(attribute.getName(), var1_1.getNamespace());
    }

    @Override
    public final Iterator<Attribute> iterator() {
        return new ALIterator(this, 0);
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void sort(Comparator<? super Attribute> comp) {
        int n;
        void var3_3;
        int[] nArray;
        if (comp == null) {
            comp = ATTRIBUTE_NATURAL;
        }
        int sz = this.size;
        int[] indexes = new int[sz];
        int i = 0;
        while (i < sz) {
            int ip;
            int n2;
            block9: {
                int n3;
                Comparator<? super Attribute> comparator = comp;
                int n4 = n3 = i;
                nArray = indexes;
                AttributeList attributeList = this;
                int n5 = 0;
                int n6 = n4 - 1;
                Attribute attribute = attributeList.attributeData[n3];
                while (n5 <= n6) {
                    n4 = n5 + n6 >>> 1;
                    n3 = comparator.compare(attribute, attributeList.attributeData[nArray[n4]]);
                    if (n3 == 0) {
                        while (n3 == 0 && n4 < n6 && comparator.compare(attribute, attributeList.attributeData[nArray[n4 + 1]]) == 0) {
                            ++n4;
                        }
                        n2 = n4 + 1;
                        break block9;
                    }
                    if (n3 < 0) {
                        n6 = n4 - 1;
                        continue;
                    }
                    n5 = n4 + 1;
                }
                n2 = ip = n5;
            }
            if (n2 < i) {
                System.arraycopy(indexes, ip, indexes, ip + 1, i - ip);
            }
            indexes[ip] = i++;
        }
        nArray = var3_3;
        AttributeList attributeList = this;
        void v1 = nArray;
        int[] nArray2 = ContentList.1.copyOf((int[])v1, ((void)v1).length);
        Arrays.sort(nArray2);
        Attribute[] attributeArray = new Attribute[nArray2.length];
        for (n = 0; n < attributeArray.length; ++n) {
            attributeArray[n] = attributeList.attributeData[nArray[n]];
        }
        for (n = 0; n < nArray.length; ++n) {
            attributeList.attributeData[nArray2[n]] = attributeArray[n];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ALIterator
    implements Iterator<Attribute> {
        private int expect = -1;
        private int cursor = 0;
        private boolean canremove = false;
        private /* synthetic */ AttributeList this$0;

        private ALIterator(AttributeList attributeList) {
            this.this$0 = attributeList;
            this.expect = attributeList.modCount;
        }

        @Override
        public final boolean hasNext() {
            return this.cursor < this.this$0.size;
        }

        @Override
        public final void remove() {
            if (this.this$0.modCount != this.expect) {
                throw new ConcurrentModificationException("ContentList was modified outside of this Iterator");
            }
            if (!this.canremove) {
                throw new IllegalStateException("Can only remove() content after a call to next()");
            }
            this.this$0.remove(--this.cursor);
            this.expect = this.this$0.modCount;
            this.canremove = false;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ALIterator(AttributeList x0, byte by) {
            this((AttributeList)var1_1);
            void var1_1;
        }
    }
}

