/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.api;

import com.io7m.jwheatsheaf.api.JWFileSizeFormatterType;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;

public final class JWFileChooserConfigurationDefaults {
    private JWFileChooserConfigurationDefaults() {
    }

    public static DateTimeFormatter fileTimeFormatter() {
        return new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendOffsetId().toFormatter();
    }

    public static JWFileSizeFormatterType fileSizeFormatter() {
        return size -> {
            if (size == -1L) {
                return "";
            }
            double real = Double.parseDouble(Long.toUnsignedString(size));
            if (Long.compareUnsigned(size, 1000L) < 0) {
                return Long.toUnsignedString(size) + "B";
            }
            if (Long.compareUnsigned(size, 1000000L) < 0) {
                return String.format("%.2fkB", real / 1000.0);
            }
            if (Long.compareUnsigned(size, 1000000000L) < 0) {
                return String.format("%.2fMB", real / 1000000.0);
            }
            if (Long.compareUnsigned(size, 1000000000000L) < 0) {
                return String.format("%.2fGB", real / 1.0E12);
            }
            return String.format("%.2fTB", real / 1.0E12);
        };
    }
}

