/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jwheatsheaf.ui.internal.JWFileChoosersTestingType;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public final class JWFileChoosersTesting
implements JWFileChoosersTestingType {
    private final Duration ioDelay;

    private JWFileChoosersTesting(Duration ioDelay) {
        this.ioDelay = ioDelay;
    }

    @Override
    public Optional<Duration> ioDelay() {
        return Optional.ofNullable(this.ioDelay);
    }

    public final JWFileChoosersTesting withIoDelay(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "ioDelay");
        if (this.ioDelay == newValue) {
            return this;
        }
        return new JWFileChoosersTesting(newValue);
    }

    public final JWFileChoosersTesting withIoDelay(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.ioDelay == value) {
            return this;
        }
        return new JWFileChoosersTesting(value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JWFileChoosersTesting && this.equalTo((JWFileChoosersTesting)another);
    }

    private boolean equalTo(JWFileChoosersTesting another) {
        return Objects.equals(this.ioDelay, another.ioDelay);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.ioDelay);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("JWFileChoosersTesting{");
        if (this.ioDelay != null) {
            builder.append("ioDelay=").append(this.ioDelay);
        }
        return builder.append("}").toString();
    }

    public static JWFileChoosersTesting copyOf(JWFileChoosersTestingType instance) {
        if (instance instanceof JWFileChoosersTesting) {
            return (JWFileChoosersTesting)instance;
        }
        return JWFileChoosersTesting.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration ioDelay;

        private Builder() {
        }

        public final Builder from(JWFileChoosersTestingType instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<Duration> ioDelayOptional = instance.ioDelay();
            if (ioDelayOptional.isPresent()) {
                this.setIoDelay(ioDelayOptional);
            }
            return this;
        }

        public final Builder setIoDelay(Duration ioDelay) {
            this.ioDelay = Objects.requireNonNull(ioDelay, "ioDelay");
            return this;
        }

        public final Builder setIoDelay(Optional<? extends Duration> ioDelay) {
            this.ioDelay = ioDelay.orElse(null);
            return this;
        }

        public JWFileChoosersTesting build() {
            return new JWFileChoosersTesting(this.ioDelay);
        }
    }
}

