/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex;

import com.whitemagicsoftware.tex.Char;
import com.whitemagicsoftware.tex.CharFont;
import com.whitemagicsoftware.tex.Extension;
import com.whitemagicsoftware.tex.FontInfo;
import com.whitemagicsoftware.tex.Metrics;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.exceptions.SymbolMappingNotFoundException;
import com.whitemagicsoftware.tex.exceptions.TextStyleMappingNotFoundException;
import com.whitemagicsoftware.tex.parsers.DefaultTeXFontParser;
import java.util.Map;

public class DefaultTeXFont
implements TeXFont {
    public static final int NO_EXTENSION = -1;
    public static final int NUMBERS = 0;
    public static final int CAPITALS = 1;
    public static final int SMALL = 2;
    public static final int UNICODE = 3;
    public static final int TOP = 0;
    public static final int MID = 1;
    public static final int REP = 2;
    public static final int BOT = 3;
    public static final int WIDTH = 0;
    public static final int HEIGHT = 1;
    public static final int DEPTH = 2;
    public static final int ITALIC = 3;
    private static final String[] defaultTextStyleMappings;
    private static final Map<String, CharFont[]> textStyleMappings;
    private static final Map<String, CharFont> symbolMappings;
    private static final Map<String, Float> parameters;
    private static final Map<String, Number> generalSettings;
    private static final FontInfo[] fontInfo;
    private static final int sMuFontId;
    private static final float sScriptFactor;
    private static final float sScriptScriptFactor;
    private static final int sSpaceFontId;
    private final float pointSize;

    /*
     * WARNING - void declaration
     */
    public DefaultTeXFont(float pointSize) {
        void var1_1;
        this.pointSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getAxisHeight(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("axisheight", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getBigOpSpacing1(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("bigopspacing1", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getBigOpSpacing2(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("bigopspacing2", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getBigOpSpacing3(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("bigopspacing3", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getBigOpSpacing4(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("bigopspacing4", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getBigOpSpacing5(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("bigopspacing5", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getDefaultRuleThickness(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("defaultrulethickness", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getDenom1(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("denom1", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getDenom2(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("denom2", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getSub1(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("sub1", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getSub2(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("sub2", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getSubDrop(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("subdrop", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getSup1(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("sup1", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getSup2(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("sup2", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getSup3(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("sup3", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getSupDrop(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("supdrop", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getNum1(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("num1", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getNum2(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("num2", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getNum3(int style) {
        void var1_1;
        return DefaultTeXFont.getResizedParameter("num3", (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getSpace(int style) {
        void var1_1;
        FontInfo fontInfo = this.getFontInfo(sSpaceFontId);
        return fontInfo.getSpace(DefaultTeXFont.getScaledSizeFactor((int)var1_1));
    }

    @Override
    public float getPointSize() {
        return this.pointSize;
    }

    /*
     * WARNING - void declaration
     */
    private static float getResizedParameter(String p, int style) {
        void var1_1;
        return DefaultTeXFont.getParameter(p) * DefaultTeXFont.getSizeFactor((int)var1_1) * TeXFormula.PIXELS_PER_POINT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Char getChar(char c, String textStyle, int style) throws TextStyleMappingNotFoundException {
        void var1_1;
        void var3_5;
        CharFont[] mapping = textStyleMappings.get(textStyle);
        if (mapping == null) {
            void var2_3;
            throw new TextStyleMappingNotFoundException((String)var2_3);
        }
        void var4_8 = var3_5;
        CharFont[] charFontArray = mapping;
        void var2_4 = var1_1;
        DefaultTeXFont defaultTeXFont = this;
        int n = 1;
        void var6_10 = var2_4 - 65;
        if (var2_4 >= 48 && var2_4 <= 57) {
            n = 0;
            var6_10 = var2_4 - 48;
        } else if (var2_4 >= 97 && var2_4 <= 122) {
            n = 2;
            var6_10 = var2_4 - 97;
        }
        if (charFontArray[n] == null) {
            return defaultTeXFont.getDefaultChar((char)var2_4, (int)var4_8);
        }
        return defaultTeXFont.getChar(new CharFont((char)(charFontArray[n].c + var6_10), charFontArray[n].fontId), (int)var4_8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Char getChar(CharFont cf, int style) {
        void var2_3;
        void var1_1;
        float size = DefaultTeXFont.getSizeFactor(style);
        return new Char(cf.c, cf.fontId, this.getMetrics((CharFont)var1_1, (float)var2_3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Char getChar(String symbolName, int style) throws SymbolMappingNotFoundException {
        void var2_2;
        void var3_3;
        CharFont charFont = symbolMappings.get(symbolName);
        if (charFont == null) {
            void var1_1;
            throw new SymbolMappingNotFoundException((String)var1_1);
        }
        return this.getChar((CharFont)var3_3, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Char getDefaultChar(char c, int style) {
        void var2_2;
        void var1_1;
        if (c >= '0' && c <= '9') {
            return this.getChar(c, defaultTextStyleMappings[0], style);
        }
        if (c >= 'a' && c <= 'z') {
            return this.getChar(c, defaultTextStyleMappings[2], style);
        }
        return this.getChar((char)var1_1, defaultTextStyleMappings[1], (int)var2_2);
    }

    @Override
    public Extension getExtension(Char c, int style) {
        int fontId = c.getFontId();
        float s = DefaultTeXFont.getSizeFactor(style);
        FontInfo fontInfo = this.getFontInfo(fontId);
        int[] ext = fontInfo.getExtension(c.getChar());
        Char[] parts = new Char[ext.length];
        for (int i = 0; i < ext.length; ++i) {
            parts[i] = ext[i] == -1 ? null : new Char((char)ext[i], fontId, this.getMetrics(new CharFont((char)ext[i], fontId), s));
        }
        return new Extension(parts[0], parts[1], parts[2], parts[3]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getKern(CharFont left, CharFont right, int style) {
        if (left.fontId == right.fontId) {
            void var3_3;
            void var2_2;
            void var1_1;
            FontInfo fontInfo = this.getFontInfo(left.fontId);
            return fontInfo.getKern(var1_1.c, var2_2.c, DefaultTeXFont.getScaledSizeFactor((int)var3_3));
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharFont getLigature(CharFont left, CharFont right) {
        if (left.fontId == right.fontId) {
            void var2_2;
            void var1_1;
            FontInfo fontInfo = this.getFontInfo(left.fontId);
            return fontInfo.getLigature(var1_1.c, var2_2.c);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Metrics getMetrics(CharFont cf, float size) {
        void var1_1;
        void var2_2;
        FontInfo fontInfo = this.getFontInfo(cf.fontId);
        float[] m = fontInfo.getMetrics(cf.c);
        void v0 = var2_2;
        return new Metrics(m[0], m[1], m[2], (float)var1_1[3], (float)v0, (float)(v0 * TeXFormula.PIXELS_PER_POINT));
    }

    @Override
    public int getMuFontId() {
        return sMuFontId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Char getNextLarger(Char c, int style) {
        void var2_3;
        void var1_1;
        FontInfo fontInfo = this.getFontInfo(c.getFontId());
        CharFont ch = fontInfo.getNextLarger(c.getChar());
        float sizeFactor = DefaultTeXFont.getSizeFactor(style);
        return new Char(ch.c, ch.fontId, this.getMetrics((CharFont)var1_1, (float)var2_3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getQuad(int style, int fontId) {
        void var1_1;
        void var2_2;
        FontInfo fontInfo = this.getFontInfo((int)var2_2);
        return fontInfo.getQuad(DefaultTeXFont.getScaledSizeFactor((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getSkew(CharFont cf, int style) {
        void var2_2;
        void var1_1;
        void var3_4;
        FontInfo fontInfo = this.getFontInfo(cf.fontId);
        char skew = fontInfo.getSkewChar();
        return this.getKern(cf, new CharFont((char)var3_4, var1_1.fontId), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getXHeight(int style, int fontCode) {
        void var1_1;
        void var2_2;
        FontInfo fontInfo = this.getFontInfo((int)var2_2);
        return fontInfo.getXHeight(DefaultTeXFont.getScaledSizeFactor((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasNextLarger(Char c) {
        void var1_1;
        FontInfo fontInfo = this.getFontInfo(c.getFontId());
        return fontInfo.getNextLarger(var1_1.getChar()) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasSpace(int font) {
        void var1_1;
        FontInfo fontInfo = this.getFontInfo((int)var1_1);
        return fontInfo.hasSpace();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isExtensionChar(Char c) {
        void var1_1;
        FontInfo fontInfo = this.getFontInfo(c.getFontId());
        return fontInfo.getExtension(var1_1.getChar()) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FontInfo getFontInfo(int fontId) {
        void var1_1;
        return fontInfo[var1_1];
    }

    private static float getParameter(String parameterName) {
        Float f;
        Float param = parameters.get(parameterName);
        if (param == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    private static float getSizeFactor(int style) {
        int n;
        if (style < 4) {
            return 1.0f;
        }
        if (n < 6) {
            return sScriptFactor;
        }
        return sScriptScriptFactor;
    }

    private static float getScaledSizeFactor(int style) {
        return DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        DefaultTeXFontParser parser = new DefaultTeXFontParser();
        parameters = parser.parseParameters();
        generalSettings = parser.parseGeneralSettings();
        textStyleMappings = parser.getParsedTextStyleMappings();
        defaultTextStyleMappings = parser.parseDefaultTextStyleMappings();
        symbolMappings = parser.parseSymbolMappings();
        fontInfo = var0.parseFontDescriptions();
        sMuFontId = generalSettings.get("mufontid").intValue();
        sScriptFactor = generalSettings.get("scriptfactor").floatValue();
        sScriptScriptFactor = generalSettings.get("scriptscriptfactor").floatValue();
        sSpaceFontId = generalSettings.get("spacefontid").intValue();
    }
}

