/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.output;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.jdom2.output.EscapeStrategy;
import org.jdom2.output.LineSeparator;

public final class Format
implements Cloneable {
    private static final EscapeStrategy UTFEscapeStrategy = new EscapeStrategyUTF(0);
    private static final EscapeStrategy Bits8EscapeStrategy = new EscapeStrategy8Bits(0);
    private static final EscapeStrategy Bits7EscapeStrategy = new EscapeStrategy7Bits(0);
    private static final EscapeStrategy DefaultEscapeStrategy = new EscapeStrategy(){};
    private static final String STANDARD_LINE_SEPARATOR = LineSeparator.DEFAULT.value();
    String indent = null;
    String lineSeparator = STANDARD_LINE_SEPARATOR;
    String encoding = "UTF-8";
    boolean omitDeclaration = false;
    boolean omitEncoding = false;
    private boolean specifiedAttributesOnly = false;
    boolean expandEmptyElements = false;
    private boolean ignoreTrAXEscapingPIs = false;
    TextMode mode = TextMode.PRESERVE;
    private EscapeStrategy escapeStrategy = DefaultEscapeStrategy;

    public static Format getRawFormat() {
        return new Format();
    }

    private static final EscapeStrategy chooseStrategy(String encoding) {
        if ("UTF-8".equalsIgnoreCase(encoding) || "UTF-16".equalsIgnoreCase(encoding)) {
            return UTFEscapeStrategy;
        }
        if (encoding.toUpperCase().startsWith("ISO-8859-") || "Latin1".equalsIgnoreCase(encoding)) {
            return Bits8EscapeStrategy;
        }
        if ("US-ASCII".equalsIgnoreCase(encoding) || "ASCII".equalsIgnoreCase(encoding)) {
            return Bits7EscapeStrategy;
        }
        try {
            CharsetEncoder charsetEncoder;
            CharsetEncoder cse = Charset.forName(encoding).newEncoder();
            return new DefaultCharsetEscapeStrategy(charsetEncoder);
        }
        catch (Exception exception) {
            return DefaultEscapeStrategy;
        }
    }

    private Format() {
        String string = "UTF-8";
        Format format = this;
        this.encoding = string;
        format.escapeStrategy = Format.chooseStrategy(string);
    }

    public final EscapeStrategy getEscapeStrategy() {
        return this.escapeStrategy;
    }

    public final String getLineSeparator() {
        return this.lineSeparator;
    }

    public final TextMode getTextMode() {
        return this.mode;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - void declaration
     */
    public final Format clone() {
        void var1_1;
        Format format = null;
        try {
            format = (Format)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return var1_1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TextMode
    extends Enum<TextMode> {
        public static final /* enum */ TextMode PRESERVE = new TextMode();
        private static /* enum */ TextMode TRIM = new TextMode();
        private static /* enum */ TextMode NORMALIZE = new TextMode();
        private static /* enum */ TextMode TRIM_FULL_WHITE = new TextMode();

        static {
            TextMode[] textModeArray = new TextMode[]{PRESERVE, TRIM, NORMALIZE, TRIM_FULL_WHITE};
        }
    }

    static final class DefaultCharsetEscapeStrategy
    implements EscapeStrategy {
        public DefaultCharsetEscapeStrategy(CharsetEncoder cse) {
        }
    }

    static final class EscapeStrategy7Bits
    implements EscapeStrategy {
        private EscapeStrategy7Bits() {
        }

        /* synthetic */ EscapeStrategy7Bits(byte by) {
            this();
        }
    }

    static final class EscapeStrategy8Bits
    implements EscapeStrategy {
        private EscapeStrategy8Bits() {
        }

        /* synthetic */ EscapeStrategy8Bits(byte by) {
            this();
        }
    }

    static final class EscapeStrategyUTF
    implements EscapeStrategy {
        private EscapeStrategyUTF() {
        }

        /* synthetic */ EscapeStrategyUTF(byte by) {
            this();
        }
    }
}

