/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jaffirm.core;

import com.io7m.jaffirm.core.ContractConditionType;
import com.io7m.jaffirm.core.ContractDoubleConditionType;
import com.io7m.jaffirm.core.ContractIntConditionType;
import com.io7m.jaffirm.core.ContractLongConditionType;
import com.io7m.jaffirm.core.PostconditionViolationException;
import com.io7m.jaffirm.core.SafeApplication;
import com.io7m.jaffirm.core.Violations;
import com.io7m.junreachable.UnreachableCodeException;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Postconditions {
    private Postconditions() {
        throw new UnreachableCodeException();
    }

    @SafeVarargs
    public static <T> T checkPostconditions(T value, ContractConditionType<T> ... conditions) throws PostconditionViolationException {
        Violations violations = Violations.innerCheckAll(value, conditions);
        if (violations != null) {
            throw Postconditions.failed(null, value, violations);
        }
        return value;
    }

    public static int checkPostconditionsI(int value, ContractIntConditionType ... conditions) throws PostconditionViolationException {
        Violations violations = Violations.innerCheckAllInt(value, conditions);
        if (violations != null) {
            throw Postconditions.failed(null, value, violations);
        }
        return value;
    }

    public static long checkPostconditionsL(long value, ContractLongConditionType ... conditions) throws PostconditionViolationException {
        Violations violations = Violations.innerCheckAllLong(value, conditions);
        if (violations != null) {
            throw Postconditions.failed(null, value, violations);
        }
        return value;
    }

    public static double checkPostconditionsD(double value, ContractDoubleConditionType ... conditions) throws PostconditionViolationException {
        Violations violations = Violations.innerCheckAllDouble(value, conditions);
        if (violations != null) {
            throw Postconditions.failed(null, value, violations);
        }
        return value;
    }

    public static <T> T checkPostcondition(T value, ContractConditionType<T> condition) throws PostconditionViolationException {
        return Postconditions.checkPostcondition(value, condition.predicate(), condition.describer());
    }

    public static <T> T checkPostcondition(T value, Predicate<T> predicate, Function<T, String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            throw Postconditions.failed(e, value, Violations.singleViolation(SafeApplication.failedPredicate(e)));
        }
        return Postconditions.innerCheck(value, ok, describer);
    }

    public static <T> T checkPostcondition(T value, boolean condition, Function<T, String> describer) {
        return Postconditions.innerCheck(value, condition, describer);
    }

    public static void checkPostcondition(boolean condition, String message) throws PostconditionViolationException {
        if (!condition) {
            throw Postconditions.failed(null, "<unspecified>", Violations.singleViolation(message));
        }
    }

    public static void checkPostcondition(boolean condition, Supplier<String> message) throws PostconditionViolationException {
        if (!condition) {
            throw Postconditions.failed(null, "<unspecified>", Violations.singleViolation(SafeApplication.applySupplierChecked(message)));
        }
    }

    public static <T> T checkPostconditionV(T value, boolean condition, String format, Object ... objects) {
        if (!condition) {
            throw Postconditions.failed(null, value, Violations.singleViolation(String.format(format, objects)));
        }
        return value;
    }

    public static void checkPostconditionV(boolean condition, String format, Object ... objects) {
        Postconditions.checkPostconditionV("<unspecified>", condition, format, objects);
    }

    public static int checkPostconditionI(int value, ContractIntConditionType condition) throws PostconditionViolationException {
        return Postconditions.checkPostconditionI(value, condition.predicate(), condition.describer());
    }

    public static int checkPostconditionI(int value, IntPredicate predicate, IntFunction<String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            throw Postconditions.failed(e, value, Violations.singleViolation(SafeApplication.failedPredicate(e)));
        }
        return Postconditions.innerCheckI(value, ok, describer);
    }

    public static int checkPostconditionI(int value, boolean condition, IntFunction<String> describer) {
        return Postconditions.innerCheckI(value, condition, describer);
    }

    public static long checkPostconditionL(long value, ContractLongConditionType condition) throws PostconditionViolationException {
        return Postconditions.checkPostconditionL(value, condition.predicate(), condition.describer());
    }

    public static long checkPostconditionL(long value, LongPredicate predicate, LongFunction<String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            throw Postconditions.failed(e, value, Violations.singleViolation(SafeApplication.failedPredicate(e)));
        }
        return Postconditions.innerCheckL(value, ok, describer);
    }

    public static long checkPostconditionL(long value, boolean condition, LongFunction<String> describer) {
        return Postconditions.innerCheckL(value, condition, describer);
    }

    public static double checkPostconditionD(double value, ContractDoubleConditionType condition) throws PostconditionViolationException {
        return Postconditions.checkPostconditionD(value, condition.predicate(), condition.describer());
    }

    public static double checkPostconditionD(double value, DoublePredicate predicate, DoubleFunction<String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            throw Postconditions.failed(e, value, Violations.singleViolation(SafeApplication.failedPredicate(e)));
        }
        return Postconditions.innerCheckD(value, ok, describer);
    }

    public static double checkPostconditionD(double value, boolean condition, DoubleFunction<String> describer) {
        return Postconditions.innerCheckD(value, condition, describer);
    }

    private static double innerCheckD(double value, boolean condition, DoubleFunction<String> describer) {
        if (!condition) {
            throw Postconditions.failed(null, value, Violations.singleViolation(SafeApplication.applyDescriberDChecked(value, describer)));
        }
        return value;
    }

    private static long innerCheckL(long value, boolean condition, LongFunction<String> describer) {
        if (!condition) {
            throw Postconditions.failed(null, value, Violations.singleViolation(SafeApplication.applyDescriberLChecked(value, describer)));
        }
        return value;
    }

    private static int innerCheckI(int value, boolean condition, IntFunction<String> describer) {
        if (!condition) {
            throw Postconditions.failed(null, value, Violations.singleViolation(SafeApplication.applyDescriberIChecked(value, describer)));
        }
        return value;
    }

    private static <T> T innerCheck(T value, boolean condition, Function<T, String> describer) {
        if (!condition) {
            throw Postconditions.failed(null, value, Violations.singleViolation(SafeApplication.applyDescriberChecked(value, describer)));
        }
        return value;
    }

    private static <T> PostconditionViolationException failed(Throwable cause, T value, Violations violations) {
        String line_separator = System.lineSeparator();
        StringBuilder sb = new StringBuilder(128);
        sb.append("Postcondition violation.");
        sb.append(line_separator);
        sb.append("  Received: ");
        sb.append(value);
        sb.append(line_separator);
        sb.append("  Violated conditions: ");
        sb.append(line_separator);
        String[] messages = violations.messages();
        for (int index = 0; index < messages.length; ++index) {
            if (messages[index] == null) continue;
            sb.append("    [");
            sb.append(index);
            sb.append("]: ");
            sb.append(messages[index]);
            sb.append(line_separator);
        }
        throw new PostconditionViolationException(sb.toString(), cause, violations.count());
    }
}

