/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui;

import com.io7m.jwheatsheaf.api.JWFileChooserConfiguration;
import com.io7m.jwheatsheaf.api.JWFileChooserFilterType;
import com.io7m.jwheatsheaf.api.JWFileChooserType;
import com.io7m.jwheatsheaf.api.JWFileChoosersType;
import com.io7m.jwheatsheaf.api.JWFileImageSetType;
import com.io7m.jwheatsheaf.ui.JWFileChooser;
import com.io7m.jwheatsheaf.ui.internal.JWFileChooserFilterAllFiles;
import com.io7m.jwheatsheaf.ui.internal.JWFileChooserFilterOnlyDirectories;
import com.io7m.jwheatsheaf.ui.internal.JWFileChooserViewController;
import com.io7m.jwheatsheaf.ui.internal.JWFileChoosersTesting;
import com.io7m.jwheatsheaf.ui.internal.JWFileImageDefaultSet;
import com.io7m.jwheatsheaf.ui.internal.JWStrings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public final class JWFileChoosers
implements JWFileChoosersType {
    private final JWFileChoosersTesting testing;
    private final ExecutorService ioExecutor;
    private final JWFileImageDefaultSet imageSet;
    private final JWStrings strings;
    private final JWFileChooserFilterType filterAllFiles;
    private final JWFileChooserFilterType filterOnlyDirectories;

    private JWFileChoosers(JWStrings inStrings, JWFileChoosersTesting inTesting, ExecutorService inIoExecutor, JWFileChooserFilterType inFilterAllFiles, JWFileChooserFilterType inFilterOnlyDirectories) {
        this.strings = Objects.requireNonNull(inStrings, "inStrings");
        this.testing = Objects.requireNonNull(inTesting, "testing");
        this.ioExecutor = Objects.requireNonNull(inIoExecutor, "ioExecutor");
        this.filterAllFiles = Objects.requireNonNull(inFilterAllFiles, "filterAllFiles");
        this.filterOnlyDirectories = Objects.requireNonNull(inFilterOnlyDirectories, "filterOnlyDirectories");
        this.imageSet = new JWFileImageDefaultSet();
    }

    public static JWFileImageSetType createDefaultIcons() {
        return new JWFileImageDefaultSet();
    }

    public static JWFileChoosersType create() {
        ExecutorService executor = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName(String.format("com.io7m.jwheatsheaf.ui.io[%d]", thread.getId()));
            return thread;
        });
        return JWFileChoosers.createWith(executor, Locale.getDefault());
    }

    public static JWFileChoosersType createWithTesting(ExecutorService executor, JWFileChoosersTesting testing, Locale locale) {
        JWStrings strings = JWStrings.of(JWStrings.getResourceBundle(locale));
        return new JWFileChoosers(strings, testing, executor, JWFileChooserFilterAllFiles.create(strings), JWFileChooserFilterOnlyDirectories.create(strings));
    }

    public static JWFileChoosersType createWith(ExecutorService executor, Locale locale) {
        JWStrings strings = JWStrings.of(JWStrings.getResourceBundle(locale));
        JWFileChoosersTesting testing = JWFileChoosersTesting.builder().build();
        return new JWFileChoosers(strings, testing, executor, JWFileChooserFilterAllFiles.create(strings), JWFileChooserFilterOnlyDirectories.create(strings));
    }

    public JWFileChooserType create(Window window, JWFileChooserConfiguration configuration) {
        Objects.requireNonNull(window, "window");
        Objects.requireNonNull(configuration, "configuration");
        try {
            URL chooserXML = JWFileChooser.class.getResource("/com/io7m/jwheatsheaf/ui/internal/chooser.fxml");
            Objects.requireNonNull(chooserXML, "chooserXML");
            ResourceBundle resources = JWStrings.getResourceBundle();
            FXMLLoader loader = new FXMLLoader(chooserXML, resources);
            Pane pane = (Pane)loader.load();
            configuration.cssStylesheet().ifPresent(url -> pane.getStylesheets().add((Object)url.toString()));
            JWFileChooserViewController viewController = (JWFileChooserViewController)loader.getController();
            viewController.setConfiguration(this, this.ioExecutor, this.testing, this.strings, this.imageSet, configuration);
            Stage dialog = new Stage(((Stage)window).getStyle());
            dialog.initModality(Modality.APPLICATION_MODAL);
            dialog.initStyle(StageStyle.DECORATED);
            dialog.setScene(new Scene((Parent)pane));
            configuration.title().ifPresentOrElse(arg_0 -> ((Stage)dialog).setTitle(arg_0), () -> {
                switch (configuration.action()) {
                    case CREATE: 
                    case OPEN_EXISTING_SINGLE: {
                        dialog.setTitle(this.strings.fileSelect());
                        break;
                    }
                    case OPEN_EXISTING_MULTIPLE: {
                        dialog.setTitle(this.strings.filesSelect());
                    }
                }
            });
            dialog.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
                if (KeyCode.ESCAPE == event.getCode()) {
                    dialog.close();
                }
            });
            return new JWFileChooser(dialog, viewController);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JWFileChooserFilterType filterForAllFiles() {
        return this.filterAllFiles;
    }

    public JWFileChooserFilterType filterForOnlyDirectories() {
        return this.filterOnlyDirectories;
    }

    public void close() {
        this.ioExecutor.shutdown();
    }
}

