/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jwheatsheaf.ui.internal.JWFileItem;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javafx.scene.control.TableCell;

final class JWFileItemTableTimeCell
extends TableCell<JWFileItem, FileTime> {
    private final DateTimeFormatter timeFormatter;

    JWFileItemTableTimeCell(DateTimeFormatter inTimeFormatter) {
        this.timeFormatter = Objects.requireNonNull(inTimeFormatter, "inTimeFormatter");
    }

    private String formatTime(FileTime item) {
        Instant instant = item.toInstant();
        OffsetDateTime time = OffsetDateTime.ofInstant(instant, ZoneId.of("UTC"));
        return this.timeFormatter.format(time);
    }

    protected void updateItem(FileTime item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.setText(null);
            return;
        }
        this.setText(this.formatTime(item));
        this.setGraphic(null);
    }
}

