/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui.internal;

import com.io7m.jwheatsheaf.api.JWFileChooserFilterType;
import com.io7m.jwheatsheaf.ui.internal.JWFileItem;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public final class JWFileList {
    private final ObservableList<JWFileItem> items;
    private final FilteredList<JWFileItem> filtered;
    private final SortedList<JWFileItem> sorted;
    private volatile String search;
    private volatile JWFileChooserFilterType filter;

    public JWFileList(JWFileChooserFilterType inFilter) {
        this.filter = Objects.requireNonNull(inFilter, "inFilter");
        this.items = FXCollections.observableArrayList();
        this.search = "";
        this.filtered = this.items.filtered(this::isItemVisible);
        this.sorted = new SortedList(this.filtered);
    }

    private boolean isItemVisible(JWFileItem item) {
        boolean allowed = this.filter.isAllowed(item.path());
        boolean searched = item.name().toUpperCase().contains(this.search.toUpperCase());
        return allowed && searched;
    }

    public void setItems(List<JWFileItem> newItems) {
        this.items.setAll(newItems);
    }

    public void setSearch(String searchText) {
        this.search = Objects.requireNonNull(searchText, "searchText");
        this.items.setAll(List.copyOf(this.items));
    }

    public void setFilter(JWFileChooserFilterType newFilter) {
        this.filter = Objects.requireNonNull(newFilter, "filter");
        this.items.setAll(List.copyOf(this.items));
    }

    public ObservableList<JWFileItem> items() {
        return this.sorted;
    }

    public ObjectProperty<Comparator<? super JWFileItem>> comparator() {
        return this.sorted.comparatorProperty();
    }
}

