/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.store.DataInput;

public class InputStreamDataInput
extends DataInput
implements Closeable {
    private final InputStream is;

    /*
     * WARNING - void declaration
     */
    public InputStreamDataInput(InputStream is) {
        void var1_1;
        this.is = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte readByte() throws IOException {
        void var1_1;
        int v = this.is.read();
        if (v == -1) {
            throw new EOFException();
        }
        return (byte)var1_1;
    }

    @Override
    public final void readBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int cnt = this.is.read(b, offset, len);
            if (cnt < 0) {
                throw new EOFException();
            }
            len -= cnt;
            offset += cnt;
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void skipBytes(long numBytes) throws IOException {
        void var1_1;
        void var3_2;
        if (numBytes < 0L) {
            throw new IllegalArgumentException("numBytes must be >= 0, got " + numBytes);
        }
        long skipped = this.is.skip(numBytes);
        assert (skipped <= numBytes);
        if (var3_2 < var1_1) {
            throw new EOFException();
        }
    }
}

