/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.ContentList;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.input.sax.BuilderErrorHandler;
import org.jdom2.input.sax.DefaultSAXHandlerFactory;
import org.jdom2.input.sax.SAXBuilderEngine;
import org.jdom2.input.sax.SAXEngine;
import org.jdom2.input.sax.SAXHandler;
import org.jdom2.input.sax.SAXHandlerFactory;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public final class SAXBuilder
implements SAXEngine {
    private static final SAXHandlerFactory DEFAULTSAXHANDLERFAC = new DefaultSAXHandlerFactory();
    private static final JDOMFactory DEFAULTJDOMFAC = new ContentList.1();
    private XMLReaderJDOMFactory readerfac = null;
    private SAXHandlerFactory handlerfac = null;
    private JDOMFactory jdomfac = null;
    private final HashMap<String, Boolean> features = new HashMap(5);
    private final HashMap<String, Object> properties = new HashMap(5);
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;
    private XMLFilter saxXMLFilter = null;
    private boolean expand = true;
    private boolean ignoringWhite = false;
    private boolean ignoringBoundaryWhite = false;
    private boolean reuseParser = true;
    private SAXEngine engine = null;

    public SAXBuilder() {
        this(null, null, null);
    }

    private SAXBuilder(XMLReaderJDOMFactory xmlreaderfactory, SAXHandlerFactory handlerfactory, JDOMFactory jdomfactory) {
        this.readerfac = XMLReaders.NONVALIDATING;
        this.handlerfac = DEFAULTSAXHANDLERFAC;
        this.jdomfac = DEFAULTJDOMFAC;
    }

    /*
     * WARNING - void declaration
     */
    private SAXEngine buildEngine() throws JDOMException {
        void var3_3;
        void var1_1;
        void var2_5;
        XMLReader xMLReader;
        SAXHandler contentHandler = this.handlerfac.createSAXHandler(this.jdomfac);
        contentHandler.setExpandEntities(this.expand);
        contentHandler.setIgnoringElementContentWhitespace(false);
        contentHandler.setIgnoringBoundaryWhitespace(false);
        SAXBuilder sAXBuilder = this;
        XMLReader parser = xMLReader = sAXBuilder.readerfac.createXMLReader();
        SAXHandler sAXHandler = contentHandler;
        xMLReader = parser;
        sAXBuilder = this;
        xMLReader.setContentHandler(sAXHandler);
        xMLReader.setDTDHandler(sAXHandler);
        xMLReader.setErrorHandler(new BuilderErrorHandler());
        boolean bl = false;
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sAXHandler);
            bl = true;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        if (!bl) {
            try {
                xMLReader.setProperty("http://xml.org/sax/handlers/LexicalHandler", sAXHandler);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        }
        for (Map.Entry<String, Boolean> entry : sAXBuilder.features.entrySet()) {
            SAXBuilder.internalSetFeature(xMLReader, entry.getKey(), entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, Object> entry : sAXBuilder.properties.entrySet()) {
            SAXBuilder.internalSetProperty(xMLReader, entry.getKey(), entry.getValue(), entry.getKey());
        }
        try {
            if (xMLReader.getFeature("http://xml.org/sax/features/external-general-entities") != sAXBuilder.expand) {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", sAXBuilder.expand);
            }
        }
        catch (SAXException sAXException) {}
        if (!sAXBuilder.expand) {
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", sAXHandler);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        }
        boolean valid = this.readerfac.isValidating();
        return new SAXBuilderEngine((XMLReader)var2_5, (SAXHandler)var1_1, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void internalSetFeature(XMLReader parser, String feature, boolean value, String displayName) throws JDOMException {
        try {
            void var2_2;
            void var1_1;
            parser.setFeature((String)var1_1, (boolean)var2_2);
            return;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(displayName + " feature not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            XMLReader xMLReader;
            void var3_3;
            throw new JDOMException((String)var3_3 + " feature not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void internalSetProperty(XMLReader parser, String property, Object value, String displayName) throws JDOMException {
        try {
            void var2_2;
            void var1_1;
            parser.setProperty((String)var1_1, var2_2);
            return;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(displayName + " property not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            XMLReader xMLReader;
            void var3_3;
            throw new JDOMException((String)var3_3 + " property not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    public final Document build(InputStream in) throws JDOMException, IOException {
        try {
            Document document;
            SAXBuilder sAXBuilder = this;
            document = (sAXBuilder.engine != null ? sAXBuilder.engine : (sAXBuilder.engine = sAXBuilder.buildEngine())).build((InputStream)((Object)document));
            return document;
        }
        finally {
            if (!this.reuseParser) {
                this.engine = null;
            }
        }
    }
}

