/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.api;

import com.io7m.jwheatsheaf.api.JWFileChooserEventType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;

public final class JWFileListingFailed
implements JWFileChooserEventType.JWFileListingFailedType {
    private final Path path;
    private final Exception exception;

    private JWFileListingFailed(Path path, Exception exception) {
        this.path = Objects.requireNonNull(path, "path");
        this.exception = Objects.requireNonNull(exception, "exception");
    }

    private JWFileListingFailed(JWFileListingFailed original, Path path, Exception exception) {
        this.path = path;
        this.exception = exception;
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public Exception exception() {
        return this.exception;
    }

    public final JWFileListingFailed withPath(Path value) {
        if (this.path == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "path");
        return new JWFileListingFailed(this, newValue, this.exception);
    }

    public final JWFileListingFailed withException(Exception value) {
        if (this.exception == value) {
            return this;
        }
        Exception newValue = Objects.requireNonNull(value, "exception");
        return new JWFileListingFailed(this, this.path, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JWFileListingFailed && this.equalTo((JWFileListingFailed)another);
    }

    private boolean equalTo(JWFileListingFailed another) {
        return this.path.equals(another.path) && this.exception.equals(another.exception);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.exception.hashCode();
        return h;
    }

    public String toString() {
        return "JWFileListingFailed{path=" + this.path + ", exception=" + this.exception + "}";
    }

    public static JWFileListingFailed of(Path path, Exception exception) {
        return new JWFileListingFailed(path, exception);
    }

    public static JWFileListingFailed copyOf(JWFileChooserEventType.JWFileListingFailedType instance) {
        if (instance instanceof JWFileListingFailed) {
            return (JWFileListingFailed)instance;
        }
        return JWFileListingFailed.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_EXCEPTION = 2L;
        private long initBits = 3L;
        private Path path;
        private Exception exception;

        private Builder() {
        }

        public final Builder from(JWFileChooserEventType.JWFileChooserEventErrorType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JWFileChooserEventType.JWFileListingFailedType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            JWFileChooserEventType.JWFileChooserEventErrorType instance;
            long bits = 0L;
            if (object instanceof JWFileChooserEventType.JWFileChooserEventErrorType) {
                instance = (JWFileChooserEventType.JWFileChooserEventErrorType)object;
                if ((bits & 1L) == 0L) {
                    this.setException(instance.exception());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setPath(instance.path());
                    bits |= 2L;
                }
            }
            if (object instanceof JWFileChooserEventType.JWFileListingFailedType) {
                instance = (JWFileChooserEventType.JWFileListingFailedType)object;
                if ((bits & 1L) == 0L) {
                    this.setException(instance.exception());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setPath(instance.path());
                    bits |= 2L;
                }
            }
        }

        public final Builder setPath(Path path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setException(Exception exception) {
            this.exception = Objects.requireNonNull(exception, "exception");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public JWFileListingFailed build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new JWFileListingFailed(null, this.path, this.exception);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("exception");
            }
            return "Cannot build JWFileListingFailed, some of required attributes are not set " + attributes;
        }
    }
}

