/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes;

import com.whitemagicsoftware.keenquotes.Lexeme;
import com.whitemagicsoftware.keenquotes.LexemeType;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.function.BiFunction;

public class Lexer {
    private final CharacterIterator mIterator;

    Lexer(String text) {
        this.mIterator = new StringCharacterIterator(text);
    }

    Lexeme next() {
        return this.parse(this.mIterator);
    }

    Lexeme parse(CharacterIterator i) {
        int began = i.getIndex();
        boolean isWord = false;
        Lexeme lexeme = null;
        while (true) {
            char next2;
            if (this.skip(i)) {
                began = i.getIndex();
                continue;
            }
            char curr = i.current();
            if (Lexer.isLetter(curr)) {
                isWord = true;
                next2 = Lexer.peek(i);
                if (!Lexer.isLetter(next2) && !Lexer.isDigit(next2)) {
                    lexeme = Lexeme.createLexeme(LexemeType.WORD, began, i.getIndex());
                }
            } else if (curr == ' ') {
                Lexer.slurp(i, (next, ci) -> next.charValue() == ' ');
                lexeme = Lexeme.createLexeme(LexemeType.SPACE, began, i.getIndex());
            } else if (curr == '\'') {
                lexeme = Lexeme.createLexeme(LexemeType.QUOTE_SINGLE, began, i.getIndex());
            } else if (curr == '\"') {
                lexeme = Lexeme.createLexeme(LexemeType.QUOTE_DOUBLE, began, i.getIndex());
            } else if (curr == '\u2018') {
                lexeme = Lexeme.createLexeme(LexemeType.QUOTE_SINGLE_OPENING, began, i.getIndex());
            } else if (curr == '\u2019') {
                lexeme = Lexeme.createLexeme(LexemeType.QUOTE_SINGLE_CLOSING, began, i.getIndex());
            } else if (Lexer.isDigit(curr) || Lexer.isNumeric(curr) && Lexer.isDigit(Lexer.peek(i))) {
                Lexer.slurp(i, (next, ci) -> Lexer.isDigit(next.charValue()) || Lexer.isNumeric(next.charValue()) && Lexer.isDigit(Lexer.peek(ci)));
                lexeme = Lexeme.createLexeme(isWord ? LexemeType.WORD : LexemeType.NUMBER, began, i.getIndex());
            } else if (curr == '-' && Lexer.peek(i) != '-') {
                lexeme = Lexeme.createLexeme(LexemeType.HYPHEN, began, i.getIndex());
            } else if (this.isDash(curr)) {
                Lexer.slurp(i, (next, ci) -> this.isDash(next.charValue()));
                lexeme = Lexeme.createLexeme(LexemeType.DASH, began, i.getIndex());
            } else if (curr == '.') {
                lexeme = Lexeme.createLexeme(Lexer.slurp(i, (next, ci) -> next.charValue() == '.' || next.charValue() == ' ' && Lexer.peek(ci) == '.') == 0 ? LexemeType.PERIOD : LexemeType.ELLIPSIS, began, i.getIndex());
            } else if (curr == '\r' || curr == '\n') {
                int[] cr = new int[]{curr == '\r' ? 1 : 0};
                int[] lf = new int[]{curr == '\n' ? 1 : 0};
                Lexer.slurp(i, (next, ci) -> {
                    cr[0] = cr[0] + (next.charValue() == '\r' ? 1 : 0);
                    lf[0] = lf[0] + (next.charValue() == '\n' ? 1 : 0);
                    return next.charValue() == '\r' || next.charValue() == '\n';
                });
                boolean eol = cr[0] + lf[0] == 1 || cr[0] == 1 && lf[0] == 1;
                lexeme = Lexeme.createLexeme(eol ? LexemeType.EOL : LexemeType.EOP, began, i.getIndex());
            } else if (Character.isWhitespace(curr)) {
                lexeme = Lexeme.createLexeme(LexemeType.SPACE, began, i.getIndex());
            } else if (curr == '\\') {
                next2 = i.next();
                if (next2 == '\'') {
                    lexeme = Lexeme.createLexeme(LexemeType.ESC_SINGLE, began, i.getIndex());
                } else if (next2 == '\"') {
                    lexeme = Lexeme.createLexeme(LexemeType.ESC_DOUBLE, began, i.getIndex());
                } else {
                    i.previous();
                }
            } else {
                lexeme = curr == '(' || curr == '{' || curr == '[' ? Lexeme.createLexeme(LexemeType.OPENING_GROUP, began, i.getIndex()) : (curr == ')' || curr == '}' || curr == ']' ? Lexeme.createLexeme(LexemeType.CLOSING_GROUP, began, i.getIndex()) : (curr == '=' ? Lexeme.createLexeme(LexemeType.EQUALS, began, i.getIndex()) : (curr != '\uffff' ? Lexeme.createLexeme(LexemeType.PUNCT, began, i.getIndex()) : Lexeme.EOT)));
            }
            i.next();
            if (lexeme != null) break;
        }
        return lexeme;
    }

    boolean skip(CharacterIterator i) {
        return false;
    }

    private static boolean isLetter(char curr) {
        return Character.isLetter(curr) || curr == '_' || curr == '*';
    }

    private static boolean isDigit(char curr) {
        return Character.isDigit(curr) || "\u00bc\u00bd\u00be\u2150\u2151\u2152\u2153\u2154\u2155\u2156\u2157\u2158\u2159\u215a\u215b\u215c\u215d\u215e".indexOf(curr) > -1;
    }

    private static boolean isNumeric(char curr) {
        return curr == '.' || curr == ',' || curr == '-' || curr == '+' || curr == '^' || curr == '\u215f' || curr == '\u2044';
    }

    private boolean isDash(char curr) {
        return curr == '-' || curr == '\u2013' || curr == '\u2014' || curr == '\u2015';
    }

    static char peek(CharacterIterator ci) {
        char ch = ci.next();
        ci.previous();
        return ch;
    }

    static int slurp(CharacterIterator ci, BiFunction<Character, CharacterIterator, Boolean> f) {
        char next;
        int count = 0;
        do {
            next = ci.next();
            ++count;
        } while (f.apply(Character.valueOf(next), ci).booleanValue());
        ci.previous();
        return --count;
    }
}

