/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

public abstract class DataInput
implements Cloneable {
    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final short readShort() throws IOException {
        void var1_1;
        byte b1 = this.readByte();
        byte by = this.readByte();
        return (short)((by & 0xFF) << 8 | var1_1 & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    private int readInt() throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        byte by = this.readByte();
        return (by & 0xFF) << 24 | (var3_3 & 0xFF) << 16 | (var2_2 & 0xFF) << 8 | var1_1 & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public final int readVInt() throws IOException {
        void var1_1;
        byte b = this.readByte();
        if (b >= 0) {
            return b;
        }
        int i = b & 0x7F;
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0xF) << 28;
        if ((var1_1 & 0xF0) == 0) {
            void var2_2;
            return (int)var2_2;
        }
        throw new IOException("Invalid vInt detected (too many bits)");
    }

    public final long readLong() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL | (long)this.readInt() << 32;
    }

    public final long readVLong() throws IOException {
        boolean bl = false;
        DataInput dataInput = this;
        byte by = dataInput.readByte();
        if (by >= 0) {
            return by;
        }
        long l = (long)by & 0x7FL;
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 7;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 14;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 21;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 28;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 35;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 42;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 49;
        if (by >= 0) {
            return l;
        }
        by = dataInput.readByte();
        l |= ((long)by & 0x7FL) << 56;
        if (by >= 0) {
            return l;
        }
        throw new IOException("Invalid vLong detected (negative values disallowed)");
    }

    /*
     * WARNING - void declaration
     */
    public final String readString() throws IOException {
        void var1_1;
        void var2_2;
        int length = this.readVInt();
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new String((byte[])var2_2, 0, (int)var1_1, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    private DataInput clone() {
        try {
            return (DataInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            void var1_1;
            throw new Error("This cannot happen: Failing to clone DataInput", (Throwable)var1_1);
        }
    }

    public abstract void skipBytes(long var1) throws IOException;
}

