/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;

public final class CharsRef
implements CharSequence,
Cloneable,
Comparable<CharsRef> {
    private static char[] EMPTY_CHARS = new char[0];
    public char[] chars;
    public int offset;
    public int length;

    public CharsRef() {
        this(EMPTY_CHARS, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    private CharsRef(char[] chars, int offset, int length) {
        void var3_3;
        void var2_2;
        CharsRef charsRef;
        this.chars = charsRef;
        this.offset = var2_2;
        this.length = var3_3;
        if (!$assertionsDisabled) {
            charsRef = this;
            if (charsRef.chars == null) {
                throw new IllegalStateException("chars is null");
            }
            if (charsRef.length < 0) {
                throw new IllegalStateException("length is negative: " + charsRef.length);
            }
            if (charsRef.length > charsRef.chars.length) {
                throw new IllegalStateException("length is out of bounds: " + charsRef.length + ",chars.length=" + charsRef.chars.length);
            }
            if (charsRef.offset < 0) {
                throw new IllegalStateException("offset is negative: " + charsRef.offset);
            }
            if (charsRef.offset > charsRef.chars.length) {
                throw new IllegalStateException("offset out of bounds: " + charsRef.offset + ",chars.length=" + charsRef.chars.length);
            }
            if (charsRef.offset + charsRef.length < 0) {
                throw new IllegalStateException("offset+length is negative: offset=" + charsRef.offset + ",length=" + charsRef.length);
            }
            if (charsRef.offset + charsRef.length > charsRef.chars.length) {
                throw new IllegalStateException("offset+length out of bounds: offset=" + charsRef.offset + ",length=" + charsRef.length + ",chars.length=" + charsRef.chars.length);
            }
        }
    }

    public final int hashCode() {
        return CharsRef.stringHashCode(this.chars, this.offset, this.length);
    }

    /*
     * WARNING - void declaration
     */
    public static int stringHashCode(char[] chars, int offset, int length) {
        void var3_3;
        void i;
        int end = offset + length;
        int result = 0;
        while (i < end) {
            result = result * 31 + chars[i];
            ++i;
        }
        return (int)var3_3;
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof CharsRef) {
            CharsRef charsRef;
            CharsRef charsRef2 = charsRef;
            charsRef = this;
            return Arrays.equals(charsRef.chars, charsRef.offset, charsRef.offset + charsRef.length, charsRef2.chars, charsRef2.offset, charsRef2.offset + charsRef2.length);
        }
        return false;
    }

    @Override
    public final String toString() {
        return new String(this.chars, this.offset, this.length);
    }

    @Override
    public final int length() {
        return this.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final char charAt(int index) {
        void var1_1;
        Objects.checkIndex(index, this.length);
        return this.chars[this.offset + var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharSequence subSequence(int start, int end) {
        void var1_1;
        void var2_2;
        Objects.checkFromToIndex(start, end, this.length);
        return new CharsRef(this.chars, this.offset + start, (int)(var2_2 - var1_1));
    }

    static {
        new UTF16SortedAsUTF8Comparator();
    }

    @Deprecated
    static final class UTF16SortedAsUTF8Comparator
    implements Comparator<CharsRef> {
        private UTF16SortedAsUTF8Comparator() {
        }
    }
}

