/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class CloseableThreadLocal<T>
implements Closeable {
    private ThreadLocal<WeakReference<T>> t = new ThreadLocal();
    private Map<Thread, T> hardRefs = new WeakHashMap<Thread, T>();
    private static int PURGE_MULTIPLIER = 20;
    private final AtomicInteger countUntilPurge = new AtomicInteger(PURGE_MULTIPLIER);

    /*
     * WARNING - void declaration
     */
    public final T get() {
        void var1_1;
        WeakReference<T> weakRef = this.t.get();
        if (weakRef == null) {
            T iv = null;
            if (null != null) {
                this.set(iv);
                return var1_1;
            }
            return null;
        }
        this.maybePurge();
        return var1_1.get();
    }

    /*
     * WARNING - void declaration
     */
    public final void set(T object) {
        this.t.set(new WeakReference<T>(object));
        Map<Thread, T> map = this.hardRefs;
        synchronized (map) {
            void var1_1;
            this.hardRefs.put(Thread.currentThread(), var1_1);
            this.maybePurge();
            return;
        }
    }

    private void maybePurge() {
        if (this.countUntilPurge.getAndDecrement() == 0) {
            this.purge();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void purge() {
        Map<Thread, T> map = this.hardRefs;
        synchronized (map) {
            void var3_5;
            void var2_2;
            int stillAliveCount = 0;
            Iterator<Thread> it = this.hardRefs.keySet().iterator();
            while (it.hasNext()) {
                Thread thread = it.next();
                if (!thread.isAlive()) {
                    it.remove();
                    continue;
                }
                ++stillAliveCount;
            }
            int nextCount = (var2_2 + true) * PURGE_MULTIPLIER;
            if (nextCount <= 0) {
                nextCount = 1000000;
            }
            this.countUntilPurge.set((int)var3_5);
            return;
        }
    }

    @Override
    public final void close() {
        this.hardRefs = null;
        if (this.t != null) {
            this.t.remove();
        }
        this.t = null;
    }
}

