/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jwheatsheaf.ui;

import com.io7m.jwheatsheaf.api.JWFileChooserEventType;
import com.io7m.jwheatsheaf.api.JWFileChooserType;
import com.io7m.jwheatsheaf.ui.internal.JWFileChooserViewController;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.stage.Stage;

final class JWFileChooser
implements JWFileChooserType {
    private final Stage window;
    private final JWFileChooserViewController viewController;

    JWFileChooser(Stage inWindow, JWFileChooserViewController inViewController) {
        this.window = Objects.requireNonNull(inWindow, "inWindow");
        this.viewController = Objects.requireNonNull(inViewController, "inViewController");
    }

    public void setEventListener(Consumer<JWFileChooserEventType> receiver) {
        this.viewController.setEventReceiver(receiver);
    }

    public List<Path> showAndWait() {
        this.window.showAndWait();
        return this.viewController.result();
    }

    public void show() {
        this.window.show();
    }

    public List<Path> result() {
        return this.viewController.result();
    }
}

