/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes;

import com.whitemagicsoftware.keenquotes.Contractions;
import com.whitemagicsoftware.keenquotes.Converter;
import com.whitemagicsoftware.keenquotes.ParserFactory;
import com.whitemagicsoftware.keenquotes.Settings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import picocli.CommandLine;

public final class KeenQuotes {
    private final Settings mSettings = new Settings(this);

    private static CommandLine.Help.ColorScheme createColourScheme() {
        return new CommandLine.Help.ColorScheme.Builder().commands(CommandLine.Help.Ansi.Style.bold).options(CommandLine.Help.Ansi.Style.fg_blue, CommandLine.Help.Ansi.Style.bold).parameters(CommandLine.Help.Ansi.Style.fg_blue).optionParams(CommandLine.Help.Ansi.Style.italic).errors(CommandLine.Help.Ansi.Style.fg_red, CommandLine.Help.Ansi.Style.bold).stackTraces(CommandLine.Help.Ansi.Style.italic).build();
    }

    public void run() {
        Settings settings = this.getSettings();
        Contractions contractions = this.createContractions(settings);
        if (settings.displayList()) {
            System.out.println(contractions.toString());
        } else {
            try {
                Converter c = new Converter(System.err::println, contractions, ParserFactory.ParserType.PARSER_PLAIN);
                System.out.print(this.convert(c));
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    private Contractions createContractions(Settings settings) {
        return new Contractions.Builder().withBeganUnambiguous(settings.getBeganUnambiguous()).withEndedUnambiguous(settings.getEndedUnambiguous()).withBeganAmbiguous(settings.getBeganAmbiguous()).withEndedAmbiguous(settings.getEndedAmbiguous()).build();
    }

    private String convert(Converter converter) throws IOException {
        return converter.apply(new String(System.in.readAllBytes()));
    }

    private Settings getSettings() {
        return this.mSettings;
    }

    private static String getVersion() {
        try {
            Properties properties = KeenQuotes.loadProperties("app.properties");
            return properties.getProperty("application.version");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Properties loadProperties(String resource) throws IOException {
        Properties properties = new Properties();
        properties.load(KeenQuotes.getResourceAsStream(KeenQuotes.getResourceName(resource)));
        return properties;
    }

    private static String getResourceName(String resource) {
        return String.format("%s/%s", KeenQuotes.getPackagePath(), resource);
    }

    private static String getPackagePath() {
        return KeenQuotes.class.getPackageName().replace('.', '/');
    }

    private static InputStream getResourceAsStream(String resource) {
        return KeenQuotes.class.getClassLoader().getResourceAsStream(resource);
    }

    public static void main(String[] args) {
        KeenQuotes app = new KeenQuotes();
        CommandLine parser = new CommandLine(app.getSettings());
        parser.setColorScheme(KeenQuotes.createColourScheme());
        int exitCode = parser.execute(args);
        CommandLine.ParseResult parseResult = parser.getParseResult();
        if (parseResult.isUsageHelpRequested()) {
            System.exit(exitCode);
        } else if (parseResult.isVersionHelpRequested()) {
            System.out.println(KeenQuotes.getVersion());
            System.exit(exitCode);
        }
    }
}

