/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.lucene.analysis.ko.dict.BinaryDictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.IOUtils;

public final class ConnectionCosts {
    private final ByteBuffer buffer;
    private final int forwardSize;

    /*
     * WARNING - void declaration
     */
    private ConnectionCosts(BinaryDictionary.ResourceScheme scheme, String resourcePath) throws IOException {
        InputStream is = null;
        try {
            is = BinaryDictionary.getResource(scheme, resourcePath.replace('.', '/') + ".dat");
            is = new BufferedInputStream(is);
            InputStreamDataInput in = new InputStreamDataInput(is);
            CodecUtil.checkHeader(in, "ko_cc", 1, 1);
            this.forwardSize = in.readVInt();
            int backwardSize = in.readVInt();
            int n = this.forwardSize * backwardSize;
            ByteBuffer tmpBuffer = ByteBuffer.allocateDirect(n << 1);
            int accum2 = 0;
            for (int j = 0; j < backwardSize; ++j) {
                for (int i = 0; i < this.forwardSize; ++i) {
                    InputStreamDataInput accum2 = in;
                    tmpBuffer.putShort((short)(accum2 += BitUtil.zigZagDecode(accum2.readVInt())));
                }
            }
            this.buffer = tmpBuffer.asReadOnlyBuffer();
        }
        catch (Throwable throwable) {
            void var3_5;
            IOUtils.closeWhileHandlingException(new Closeable[]{var3_5});
            throw throwable;
        }
        IOUtils.close(is);
    }

    private ConnectionCosts() throws IOException {
        this(BinaryDictionary.ResourceScheme.CLASSPATH, ConnectionCosts.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    public final int get(int forwardId, int backwardId) {
        void var1_1;
        int offset = backwardId * this.forwardSize + forwardId << 1;
        return this.buffer.getShort((int)var1_1);
    }

    public static ConnectionCosts getInstance() {
        return SingletonHolder.INSTANCE;
    }

    static final class SingletonHolder {
        static final ConnectionCosts INSTANCE;

        /*
         * WARNING - void declaration
         */
        static {
            try {
                INSTANCE = new ConnectionCosts();
                return;
            }
            catch (IOException ioe) {
                void var0;
                throw new RuntimeException("Cannot load ConnectionCosts.", (Throwable)var0);
            }
        }
    }
}

