/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jaffirm.core;

import com.io7m.jaffirm.core.ContractConditionType;
import com.io7m.jaffirm.core.ContractDoubleConditionType;
import com.io7m.jaffirm.core.ContractIntConditionType;
import com.io7m.jaffirm.core.ContractLongConditionType;
import com.io7m.jaffirm.core.PreconditionViolationException;
import com.io7m.jaffirm.core.SafeApplication;
import com.io7m.jaffirm.core.Violations;
import com.io7m.junreachable.UnreachableCodeException;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Preconditions {
    private Preconditions() {
        throw new UnreachableCodeException();
    }

    @SafeVarargs
    public static <T> T checkPreconditions(T value, ContractConditionType<T> ... conditions) throws PreconditionViolationException {
        Violations violations = Violations.innerCheckAll(value, conditions);
        if (violations != null) {
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    public static int checkPreconditionsI(int value, ContractIntConditionType ... conditions) throws PreconditionViolationException {
        Violations violations = Violations.innerCheckAllInt(value, conditions);
        if (violations != null) {
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    public static long checkPreconditionsL(long value, ContractLongConditionType ... conditions) throws PreconditionViolationException {
        Violations violations = Violations.innerCheckAllLong(value, conditions);
        if (violations != null) {
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    public static double checkPreconditionsD(double value, ContractDoubleConditionType ... conditions) throws PreconditionViolationException {
        Violations violations = Violations.innerCheckAllDouble(value, conditions);
        if (violations != null) {
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    public static <T> T checkPrecondition(T value, ContractConditionType<T> condition) throws PreconditionViolationException {
        return Preconditions.checkPrecondition(value, condition.predicate(), condition.describer());
    }

    public static <T> T checkPrecondition(T value, Predicate<T> predicate, Function<T, String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            Violations violations = Violations.singleViolation(SafeApplication.failedPredicate(e));
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), e, violations.count());
        }
        return Preconditions.innerCheck(value, ok, describer);
    }

    public static <T> T checkPrecondition(T value, boolean condition, Function<T, String> describer) {
        return Preconditions.innerCheck(value, condition, describer);
    }

    public static void checkPrecondition(boolean condition, String message) throws PreconditionViolationException {
        if (!condition) {
            Violations violations = Violations.singleViolation(message);
            throw new PreconditionViolationException(Preconditions.failedMessage("<unspecified>", violations), null, violations.count());
        }
    }

    public static void checkPrecondition(boolean condition, Supplier<String> message) throws PreconditionViolationException {
        if (!condition) {
            Violations violations = Violations.singleViolation(SafeApplication.applySupplierChecked(message));
            throw new PreconditionViolationException(Preconditions.failedMessage("<unspecified>", violations), null, violations.count());
        }
    }

    public static <T> T checkPreconditionV(T value, boolean condition, String format, Object ... objects) {
        if (!condition) {
            Violations violations = Violations.singleViolation(String.format(format, objects));
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    public static void checkPreconditionV(boolean condition, String format, Object ... objects) {
        Preconditions.checkPreconditionV("<unspecified>", condition, format, objects);
    }

    public static int checkPreconditionI(int value, ContractIntConditionType condition) throws PreconditionViolationException {
        return Preconditions.checkPreconditionI(value, condition.predicate(), condition.describer());
    }

    public static int checkPreconditionI(int value, IntPredicate predicate, IntFunction<String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            Violations violations = Violations.singleViolation(SafeApplication.failedPredicate(e));
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), e, violations.count());
        }
        return Preconditions.innerCheckI(value, ok, describer);
    }

    public static int checkPreconditionI(int value, boolean condition, IntFunction<String> describer) {
        return Preconditions.innerCheckI(value, condition, describer);
    }

    public static long checkPreconditionL(long value, ContractLongConditionType condition) throws PreconditionViolationException {
        return Preconditions.checkPreconditionL(value, condition.predicate(), condition.describer());
    }

    public static long checkPreconditionL(long value, LongPredicate predicate, LongFunction<String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            Violations violations = Violations.singleViolation(SafeApplication.failedPredicate(e));
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), e, violations.count());
        }
        return Preconditions.innerCheckL(value, ok, describer);
    }

    public static long checkPreconditionL(long value, boolean condition, LongFunction<String> describer) {
        return Preconditions.innerCheckL(value, condition, describer);
    }

    public static double checkPreconditionD(double value, ContractDoubleConditionType condition) throws PreconditionViolationException {
        return Preconditions.checkPreconditionD(value, condition.predicate(), condition.describer());
    }

    public static double checkPreconditionD(double value, DoublePredicate predicate, DoubleFunction<String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            Violations violations = Violations.singleViolation(SafeApplication.failedPredicate(e));
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), e, violations.count());
        }
        return Preconditions.innerCheckD(value, ok, describer);
    }

    public static double checkPreconditionD(double value, boolean condition, DoubleFunction<String> describer) {
        return Preconditions.innerCheckD(value, condition, describer);
    }

    private static <T> T innerCheck(T value, boolean condition, Function<T, String> describer) {
        if (!condition) {
            Violations violations = Violations.singleViolation(SafeApplication.applyDescriberChecked(value, describer));
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    private static int innerCheckI(int value, boolean condition, IntFunction<String> describer) {
        if (!condition) {
            Violations violations = Violations.singleViolation(SafeApplication.applyDescriberIChecked(value, describer));
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    private static long innerCheckL(long value, boolean condition, LongFunction<String> describer) {
        if (!condition) {
            Violations violations = Violations.singleViolation(SafeApplication.applyDescriberLChecked(value, describer));
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    private static double innerCheckD(double value, boolean condition, DoubleFunction<String> describer) {
        if (!condition) {
            Violations violations = Violations.singleViolation(SafeApplication.applyDescriberDChecked(value, describer));
            throw new PreconditionViolationException(Preconditions.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    private static <T> String failedMessage(T value, Violations violations) {
        String line_separator = System.lineSeparator();
        StringBuilder sb = new StringBuilder(128);
        sb.append("Precondition violation.");
        sb.append(line_separator);
        sb.append("  Received: ");
        sb.append(value);
        sb.append(line_separator);
        sb.append("  Violated conditions: ");
        sb.append(line_separator);
        String[] messages = violations.messages();
        for (int index = 0; index < messages.length; ++index) {
            if (messages[index] == null) continue;
            sb.append("    [");
            sb.append(index);
            sb.append("]: ");
            sb.append(messages[index]);
            sb.append(line_separator);
        }
        return sb.toString();
    }
}

