/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jaffirm.core;

import com.io7m.jaffirm.core.ContractConditionType;
import com.io7m.jaffirm.core.ContractDoubleConditionType;
import com.io7m.jaffirm.core.ContractIntConditionType;
import com.io7m.jaffirm.core.ContractLongConditionType;
import com.io7m.jaffirm.core.SafeApplication;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;

final class Violations {
    private final String[] messages;
    private int count;

    private Violations(int expected) {
        this.messages = new String[expected];
        this.count = 0;
    }

    static Violations singleViolation(String message) {
        Violations violations = new Violations(1);
        violations.messages[0] = message;
        violations.count = 1;
        return violations;
    }

    @SafeVarargs
    static <T> Violations innerCheckAll(T value, ContractConditionType<T> ... conditions) {
        Violations violations = null;
        for (int index = 0; index < conditions.length; ++index) {
            boolean ok;
            ContractConditionType<T> condition = conditions[index];
            Predicate<T> predicate = condition.predicate();
            int count = conditions.length;
            try {
                ok = predicate.test(value);
            }
            catch (Throwable e) {
                violations = Violations.maybeAllocate(violations, count);
                violations.messages()[index] = SafeApplication.failedPredicate(e);
                violations.countUp();
                continue;
            }
            if (ok) continue;
            violations = Violations.maybeAllocate(violations, count);
            violations.messages()[index] = SafeApplication.applyDescriberChecked(value, condition.describer());
            violations.countUp();
        }
        return violations;
    }

    static Violations innerCheckAllInt(int value, ContractIntConditionType ... conditions) {
        Violations violations = null;
        for (int index = 0; index < conditions.length; ++index) {
            boolean ok;
            ContractIntConditionType condition = conditions[index];
            IntPredicate predicate = condition.predicate();
            int count = conditions.length;
            try {
                ok = predicate.test(value);
            }
            catch (Throwable e) {
                violations = Violations.maybeAllocate(violations, count);
                violations.messages()[index] = SafeApplication.failedPredicate(e);
                violations.countUp();
                continue;
            }
            if (ok) continue;
            violations = Violations.maybeAllocate(violations, count);
            violations.messages()[index] = SafeApplication.applyDescriberIChecked(value, condition.describer());
            violations.countUp();
        }
        return violations;
    }

    static Violations innerCheckAllLong(long value, ContractLongConditionType ... conditions) {
        Violations violations = null;
        for (int index = 0; index < conditions.length; ++index) {
            boolean ok;
            ContractLongConditionType condition = conditions[index];
            LongPredicate predicate = condition.predicate();
            int count = conditions.length;
            try {
                ok = predicate.test(value);
            }
            catch (Throwable e) {
                violations = Violations.maybeAllocate(violations, count);
                violations.messages()[index] = SafeApplication.failedPredicate(e);
                violations.countUp();
                continue;
            }
            if (ok) continue;
            violations = Violations.maybeAllocate(violations, count);
            violations.messages()[index] = SafeApplication.applyDescriberLChecked(value, condition.describer());
            violations.countUp();
        }
        return violations;
    }

    static Violations innerCheckAllDouble(double value, ContractDoubleConditionType ... conditions) {
        Violations violations = null;
        for (int index = 0; index < conditions.length; ++index) {
            boolean ok;
            ContractDoubleConditionType condition = conditions[index];
            DoublePredicate predicate = condition.predicate();
            int count = conditions.length;
            try {
                ok = predicate.test(value);
            }
            catch (Throwable e) {
                violations = Violations.maybeAllocate(violations, count);
                violations.messages()[index] = SafeApplication.failedPredicate(e);
                violations.countUp();
                continue;
            }
            if (ok) continue;
            violations = Violations.maybeAllocate(violations, count);
            violations.messages()[index] = SafeApplication.applyDescriberDChecked(value, condition.describer());
            violations.countUp();
        }
        return violations;
    }

    private static Violations maybeAllocate(Violations violations, int count) {
        return violations == null ? new Violations(count) : violations;
    }

    String[] messages() {
        return this.messages;
    }

    int count() {
        return this.count;
    }

    private void countUp() {
        ++this.count;
    }
}

