/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.BytesRef;

public final class UnicodeUtil {
    private UnicodeUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static int UTF16toUTF8(char[] source, int offset, int length, byte[] out) {
        int upto = 0;
        int i = offset;
        int end = offset + length;
        while (i < end) {
            char utf32;
            char code;
            if ((code = source[i++]) < '\u0080') {
                out[upto++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto++] = (byte)(0xC0 | code >> 6);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                out[upto++] = (byte)(0xE0 | code >> 12);
                out[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i < end && (utf32 = source[i]) >= '\udc00' && utf32 <= '\udfff') {
                void var2_2;
                utf32 = (var2_2 << 10) + utf32 + -56613888;
                ++i;
                out[upto++] = (byte)(0xF0 | utf32 >> 18);
                out[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto++] = -17;
            out[upto++] = -65;
            out[upto++] = -67;
        }
        return upto;
    }

    public static int maxUTF8Length(int utf16Length) {
        return Math.multiplyExact(utf16Length, 3);
    }

    static {
        UnicodeUtil.class.desiredAssertionStatus();
        new BytesRef(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
        Arrays.stream(new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE}, {Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE}, {Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE}, {Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}, {4, 4, 4, 4, 4, 4, 4, 4}}).flatMapToInt(Arrays::stream).toArray();
    }
}

