/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes;

import com.whitemagicsoftware.keenquotes.Lexer;
import java.text.CharacterIterator;
import java.util.Set;

final class XmlLexer
extends Lexer {
    private final String mText;
    private final Set<String> UNTOUCHABLE = Set.of("pre", "code", "tt", "tex", "kbd", "samp", "var", "l", "blockcode");

    XmlLexer(String text) {
        super(text);
        this.mText = text;
    }

    @Override
    boolean skip(CharacterIterator i) {
        String openingTag;
        boolean match;
        boolean bl = match = i.current() == '<';
        if (match && this.UNTOUCHABLE.contains((openingTag = this.nextTag(i)).toLowerCase())) {
            String closingTag;
            while (!(closingTag = this.nextTag(i)).endsWith(openingTag) && i.current() != '\uffff') {
            }
        }
        return match;
    }

    private String nextTag(CharacterIterator i) {
        int begin = i.getIndex();
        XmlLexer.slurp(i, (next, ci) -> next.charValue() != '>' && next.charValue() != '<');
        i.next();
        i.next();
        return this.mText.substring(begin + 1, i.getIndex() - 1);
    }
}

