/*
 * Decompiled with CFR 0.152.
 */
package com.panemu.tiwulfx.control.dock;

import javafx.scene.Node;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.VLineTo;

public class TabDropHint {
    private double tabPos;
    private double width;
    private double height;
    private double startX;
    private double startY;
    private final Path path = new Path();

    public TabDropHint() {
        this.path.getStyleClass().add((Object)"drop-path");
    }

    void refresh(double startX, double startY, double width, double height) {
        boolean regenerate = this.tabPos != -1.0 || this.width != width || this.height != height || this.startX != startX || this.startY != startY;
        this.tabPos = -1.0;
        this.width = width;
        this.height = height;
        this.startX = startX;
        this.startY = startY;
        if (regenerate) {
            this.generateAdjacentPath(this.path, startX + 2.0, startY + 2.0, width - 4.0, height - 4.0);
        }
    }

    void refresh(double tabPos, double width, double height) {
        boolean regenerate = this.tabPos != tabPos || this.width != width || this.height != height;
        this.tabPos = tabPos;
        this.width = width;
        this.height = height;
        this.startX = 0.0;
        this.startY = 0.0;
        if (regenerate) {
            this.generateInsertionPath(this.path, tabPos, width - 2.0, height - 2.0);
        }
    }

    protected void generateAdjacentPath(Path path, double startX, double startY, double width, double height) {
        path.getElements().clear();
        MoveTo moveTo = new MoveTo();
        moveTo.setX(startX);
        moveTo.setY(startY);
        path.getElements().add((Object)moveTo);
        path.getElements().add((Object)new HLineTo(startX + width));
        path.getElements().add((Object)new VLineTo(startY + height));
        path.getElements().add((Object)new HLineTo(startX));
        path.getElements().add((Object)new VLineTo(startY));
    }

    protected void generateInsertionPath(Path path, double tabPos, double width, double height) {
        int tabHeight = 28;
        int start = 2;
        tabPos = Math.max((double)start, tabPos);
        path.getElements().clear();
        MoveTo moveTo = new MoveTo();
        moveTo.setX((double)start);
        moveTo.setY((double)tabHeight);
        path.getElements().add((Object)moveTo);
        path.getElements().add((Object)new HLineTo(width));
        path.getElements().add((Object)new VLineTo(height));
        path.getElements().add((Object)new HLineTo((double)start));
        path.getElements().add((Object)new VLineTo((double)tabHeight));
        if (tabPos > 20.0) {
            path.getElements().add((Object)new MoveTo(tabPos, (double)(tabHeight + 5)));
            path.getElements().add((Object)new LineTo(Math.max((double)start, tabPos - 10.0), (double)(tabHeight + 15)));
            path.getElements().add((Object)new HLineTo(tabPos + 10.0));
            path.getElements().add((Object)new LineTo(tabPos, (double)(tabHeight + 5)));
        } else {
            double tip = Math.max(tabPos, (double)(start + 5));
            path.getElements().add((Object)new MoveTo(tip, (double)(tabHeight + 5)));
            path.getElements().add((Object)new LineTo(tip + 10.0, (double)(tabHeight + 5)));
            path.getElements().add((Object)new LineTo(tip, (double)(tabHeight + 15)));
            path.getElements().add((Object)new VLineTo((double)(tabHeight + 5)));
        }
    }

    public Node getPath() {
        return this.path;
    }
}

