/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.CharFont;
import com.whitemagicsoftware.tex.Dummy;
import com.whitemagicsoftware.tex.Glue;
import com.whitemagicsoftware.tex.Row;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.CharSymbolAtom;
import com.whitemagicsoftware.tex.atoms.FixedCharAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.HorizontalBox;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.exceptions.EmptyFormulaException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class RowAtom
extends Atom
implements Row {
    private List<Atom> elements = new LinkedList<Atom>();
    private Dummy previousAtom;
    private static final BitSet binSet = new BitSet(16);
    private static final BitSet ligKernSet;

    protected RowAtom() {
    }

    /*
     * WARNING - void declaration
     */
    public RowAtom(Atom el) {
        if (el != null) {
            void var1_1;
            if (el instanceof RowAtom) {
                this.elements.addAll(((RowAtom)el).elements);
                return;
            }
            this.elements.add((Atom)var1_1);
        }
    }

    public RowAtom(List<TeXFormula> l) throws EmptyFormulaException {
        Iterator iterator;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            TeXFormula teXFormula = (TeXFormula)iterator.next();
            Atom root = teXFormula.getRoot();
            if (root == null) continue;
            this.elements.add((Atom)((Object)teXFormula));
        }
        if (this.elements.isEmpty()) {
            throw new EmptyFormulaException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void add(Atom el) {
        if (el != null) {
            void var1_1;
            this.elements.add((Atom)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Box createBox(TeXEnvironment env) {
        void var3_3;
        TeXFont tf = env.getTeXFont();
        HorizontalBox hBox = new HorizontalBox(env.getColor(), env.getBackground());
        env.reset();
        ListIterator<Atom> it = this.elements.listIterator();
        while (it.hasNext()) {
            int n;
            Dummy atom = new Dummy(it.next());
            Object nextAtom = null;
            if (it.hasNext()) {
                nextAtom = it.next();
                it.previous();
            }
            Atom atom2 = nextAtom;
            Dummy dummy = this.previousAtom;
            nextAtom = atom;
            int n2 = ((Dummy)nextAtom).getLeftType();
            if (n2 == 2 && (dummy == null || binSet.get(dummy.getRightType()))) {
                ((Dummy)nextAtom).setType(0);
            } else if (atom2 != null && ((Dummy)nextAtom).getRightType() == 2 && ((n = atom2.getLeftType()) == 3 || n == 5 || n == 6)) {
                ((Dummy)nextAtom).setType(0);
            }
            float kern = 0.0f;
            if (it.hasNext() && atom.getRightType() == 0 && atom.isCharSymbol()) {
                Atom next = it.next();
                if (next instanceof CharSymbolAtom && ligKernSet.get(next.getLeftType())) {
                    atom.markAsTextSymbol();
                    CharFont l = atom.getCharFont(tf);
                    CharFont r = ((CharSymbolAtom)next).getCharFont(tf);
                    CharFont lig = tf.getLigature(l, r);
                    if (lig == null) {
                        kern = tf.getKern(l, r, env.getStyle());
                        it.previous();
                    } else {
                        atom.changeAtom(new FixedCharAtom(lig));
                    }
                } else {
                    it.previous();
                }
            }
            if (it.previousIndex() != 0 && this.previousAtom != null && !this.previousAtom.isKern() && !atom.isKern()) {
                hBox.add(Glue.get(this.previousAtom.getRightType(), atom.getLeftType(), env));
            }
            atom.setPreviousAtom(this.previousAtom);
            Box b = atom.createBox(env);
            hBox.add(b);
            env.setLastFontId(b.getLastFontId());
            if (kern > 1.0E-7f) {
                hBox.add(new StrutBox(0.0f, kern, 0.0f, 0.0f));
            }
            if (atom.isKern()) continue;
            this.previousAtom = atom;
        }
        this.previousAtom = null;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPreviousAtom(Dummy prev) {
        void var1_1;
        this.previousAtom = var1_1;
    }

    @Override
    public int getLeftType() {
        if (this.elements.isEmpty()) {
            return 0;
        }
        return this.elements.get(0).getLeftType();
    }

    @Override
    public int getRightType() {
        if (this.elements.isEmpty()) {
            return 0;
        }
        return this.elements.get(this.elements.size() - 1).getRightType();
    }

    static {
        binSet.set(2);
        binSet.set(1);
        binSet.set(3);
        binSet.set(4);
        binSet.set(6);
        ligKernSet = new BitSet(16);
        ligKernSet.set(0);
        ligKernSet.set(1);
        ligKernSet.set(2);
        ligKernSet.set(3);
        ligKernSet.set(4);
        ligKernSet.set(5);
        ligKernSet.set(6);
    }
}

